/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.terms.replaceable.MutableRenaming;
import charlie.trs.TRS;
import charlie.util.FixedList;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.command.Command;
import cora.rwinduction.command.DeductionCommand;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.deduction.DeductionPostulate;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.ArrayList;
import java.util.Optional;

public class CommandPostulate
extends DeductionCommand {
    @Override
    public String queryName() {
        return "postulate";
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of("postulate <equation>");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Use this deduction rule to introduce a new equation into the set of goals.", new Object[0]);
        module.println("(Doing this causes completeness of the proof state to be lost.)", new Object[0]);
    }

    @Override
    protected DeductionPostulate createStep(CommandParsingStatus input) {
        TRS trs = this._proof.getContext().getTRS();
        Pair<Equation, MutableRenaming> pair = input.readEquation(trs, this._module);
        if (pair == null) {
            return null;
        }
        return DeductionPostulate.createStep(this._proof, Optional.of(this._module), pair.fst(), pair.snd());
    }

    public ArrayList<Command.TabSuggestion> suggestNext(String args) {
        ArrayList<Command.TabSuggestion> ret = new ArrayList<Command.TabSuggestion>();
        ret.add(new Command.TabSuggestion(null, "equation"));
        return ret;
    }
}

