/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.terms.CalculationSymbol;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TheoryFactory;
import charlie.terms.Variable;
import charlie.terms.replaceable.Renaming;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.types.Arrow;
import charlie.types.Type;
import charlie.util.FixedList;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.command.Command;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.ArrayList;

public class CommandRules
extends Command {
    @Override
    public String queryName() {
        return ":rules";
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of(":rules", ":rules <function symbol>");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("List all the rules available in the original TRS.", new Object[0]);
        module.println("You can also list only the rules with a specific root symbol.", new Object[0]);
    }

    public ArrayList<Command.TabSuggestion> suggestNext(String args) {
        ArrayList<Command.TabSuggestion> ret = new ArrayList<Command.TabSuggestion>();
        ret.add(this.endOfCommandSuggestion());
        if (!args.equals("")) {
            return ret;
        }
        for (FunctionSymbol f : this._proof.getContext().getTRS().definedSymbols()) {
            ret.add(new Command.TabSuggestion(f.queryName(), "defined symbol"));
        }
        return ret;
    }

    @Override
    protected boolean run(CommandParsingStatus input) {
        if (input.commandEnded()) {
            this.printAllMatchingRules(null);
            return true;
        }
        FunctionSymbol f = input.readSymbol(this._proof.getContext().getTRS(), this._module);
        if (f == null) {
            return false;
        }
        if (!input.commandEnded()) {
            this._module.println("Unexpected argument at position %a: :rules takes at most 1 argument.", input.currentPosition());
            return false;
        }
        this.printAllMatchingRules(f);
        this.printCalculationRule(f);
        return true;
    }

    private void printAllMatchingRules(FunctionSymbol start) {
        ProofContext pc = this._proof.getContext();
        TRS trs = pc.getTRS();
        boolean printed = false;
        for (int i = 0; i < trs.queryRuleCount(); ++i) {
            Rule rule = trs.queryRule(i);
            FunctionSymbol f = rule.queryRoot();
            if (start != null && f != null && !start.equals(f)) continue;
            if (!printed) {
                this._module.startTable();
                printed = true;
            }
            String name = pc.getRuleName(i);
            Renaming renaming = pc.getRenaming(name);
            this._module.nextColumn("%a:", name);
            this._module.println("%a", new Pair<Rule, Renaming>(rule, renaming));
        }
        if (printed) {
            this._module.endTable();
        } else if (start == null) {
            this._module.println("This TRS has no rules.", new Object[0]);
        } else {
            this._module.println("There are no rules with " + start.toString() + " as root symbol.", new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void printCalculationRule(FunctionSymbol start) {
        Term left;
        if (start == null) {
            return;
        }
        CalculationSymbol calculationSymbol = left = start.toCalculationSymbol();
        if (left == null) {
            return;
        }
        int i = 1;
        while (true) {
            Type type;
            if (!((type = left.queryType()) instanceof Arrow)) {
                Variable right = TermFactory.createVar("z", left.queryType());
                Term constraint = TheoryFactory.createEquality(right, left);
                this._module.println("The calculation rule for this symbol is: %a %{ruleArrow} %a | %a .", left, right, constraint);
                return;
            }
            Arrow arrow = (Arrow)type;
            try {
                Type type2;
                Type in = type2 = arrow.left();
                Type out = type2 = arrow.right();
                left = left.apply(TermFactory.createVar("x" + i, in));
                ++i;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }
}

