/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.rwinduction.command.Command;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.ProofState;
import cora.rwinduction.parser.CommandParsingStatus;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class CommandSave
extends Command {
    @Override
    public String queryName() {
        return ":save";
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of(":save <file>");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Saves the history of the current state to a file, from which it can be reloaded once you start a fresh proof attempt.", new Object[0]);
    }

    public ArrayList<Command.TabSuggestion> suggestNext(String args) {
        ArrayList<Command.TabSuggestion> ret = new ArrayList<Command.TabSuggestion>();
        if (args.equals("")) {
            ret.add(new Command.TabSuggestion(null, "<filename>"));
        } else {
            ret.add(this.endOfCommandSuggestion());
        }
        return ret;
    }

    @Override
    protected boolean run(CommandParsingStatus input) {
        String filename = input.readRest().trim();
        if (filename.length() > 2 && filename.charAt(0) == '\"' && filename.charAt(filename.length() - 1) == '\"') {
            filename = filename.substring(1, filename.length() - 1);
        }
        if (filename.equals("")) {
            this._module.println("Cannot save to an empty file.", new Object[0]);
            return false;
        }
        String history = this.storeHistory();
        try {
            FileWriter filewriter = new FileWriter(filename, false);
            filewriter.write(history);
            filewriter.close();
            this._module.println("Original equations and command history have been written to %a.", filename);
        }
        catch (IOException e) {
            this._module.println("Could not write to %a: %a.", filename, e.getMessage());
        }
        return true;
    }

    String storeHistory() {
        Printer pp = PrinterFactory.createParseablePrinter(this._proof.getContext().getTRS());
        this.printGoals(pp);
        this.printCommands(pp);
        return pp.toString();
    }

    private void printGoals(Printer printer) {
        ProofState firstState = this._proof.getDeductionHistory().size() > 0 ? this._proof.getDeductionHistory().get(0).getOriginalState() : this._proof.getProofState();
        for (EquationContext ec : firstState.getEquations()) {
            printer.add("GOAL ");
            ec.print(printer);
            printer.add(System.lineSeparator());
        }
    }

    private void printCommands(Printer printer) {
        ArrayList<String> commands = this._proof.getCommandHistory();
        for (String cmd : commands) {
            printer.add(cmd);
            printer.add(System.lineSeparator());
        }
    }
}

