/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.substitution.Substitution;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.replaceable.Renaming;
import charlie.trs.Rule;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.command.Command;
import cora.rwinduction.command.ReductionCommandInherit;
import cora.rwinduction.engine.EquationPosition;
import cora.rwinduction.engine.automation.AutoSimplifier;
import cora.rwinduction.engine.deduction.DeductionSimplify;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.ArrayList;
import java.util.Optional;
import java.util.TreeSet;

public class CommandSimplify
extends ReductionCommandInherit {
    public CommandSimplify() {
        super("simplify", "<rule>");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Use this deduction rule to rewrite the current equation with one of the known rules, which might apply to some subterm of the left- or right-hand side of the equation.", new Object[0]);
        module.println("Note that rule names can be found using :rules, and positions have the form L.<position> or R.<position>.", new Object[0]);
        module.println("To simplify with a calculation rule, use the calc command instead.", new Object[0]);
    }

    @Override
    protected final void addTabSuggestionsForKind(TreeSet<FunctionSymbol> symbols, ArrayList<Command.TabSuggestion> suggestions) {
        for (int i = 0; i < this._proof.getContext().getTRS().queryRuleCount(); ++i) {
            Rule rule = this._proof.getContext().getTRS().queryRule(i);
            if (rule.queryLeftSide().isFunctionalTerm() && !symbols.contains(rule.queryLeftSide().queryRoot())) continue;
            suggestions.add(new Command.TabSuggestion(this._proof.getContext().getRuleName(i), "rule"));
        }
    }

    @Override
    protected final Term getLeftFor(String ruleName) {
        Rule rule = this._proof.getContext().getRule(ruleName);
        if (rule == null) {
            return null;
        }
        return rule.queryLeftSide();
    }

    @Override
    protected DeductionSimplify createStep(CommandParsingStatus input) {
        if (input.commandEnded()) {
            return AutoSimplifier.createSingleStep(this._proof, this._module);
        }
        String ruleName = this.readRuleName(input);
        if (ruleName == null) {
            return null;
        }
        Renaming ruleRenaming = this._proof.getContext().getRenaming(ruleName);
        Pair<EquationPosition, Substitution> pair = this.readCommandRemainder(ruleRenaming, input);
        if (pair == null) {
            return null;
        }
        return DeductionSimplify.createStep(this._proof, Optional.of(this._module), ruleName, pair.fst(), pair.snd());
    }

    private String readRuleName(CommandParsingStatus input) {
        String txt = input.nextWord();
        if (txt != null && this._proof.getContext().hasRule(txt)) {
            return txt;
        }
        if (txt == null) {
            this._module.println("Simplify should be invoked with at least 1 argument.", new Object[0]);
        } else {
            this._module.println("No such rule: " + txt, new Object[0]);
        }
        return null;
    }
}

