/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.rwinduction.command.CmdList;
import cora.rwinduction.command.Command;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.ArrayList;

public class CommandSyntax
extends Command {
    private CmdList _clist;

    public CommandSyntax(CmdList lst) {
        this._clist = lst;
    }

    @Override
    public String queryName() {
        return ":syntax";
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of(":syntax <command>");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Query the ways to invoke a given command.", new Object[0]);
    }

    public ArrayList<Command.TabSuggestion> suggestNext(String args) {
        ArrayList<Command.TabSuggestion> ret = new ArrayList<Command.TabSuggestion>();
        if (!args.equals("")) {
            ret.add(this.endOfCommandSuggestion());
        } else {
            for (String name : this._clist.queryCommands()) {
                ret.add(new Command.TabSuggestion(name, "command"));
            }
        }
        return ret;
    }

    @Override
    protected boolean run(CommandParsingStatus input) {
        CommandSyntax cmd;
        String cmdname = input.nextWord();
        if (!input.commandEnded()) {
            this._module.println("Unexpected argument at position %a: :syntax takes at most 1 argument.", input.currentPosition());
        }
        Command command = cmd = cmdname == null ? this : this._clist.queryCommand(cmdname);
        if (cmd == null) {
            return this.failure("Unknown command: " + cmdname);
        }
        this._module.println("Syntax for the command %a:", ((Command)cmd).queryName());
        this._module.startTable();
        for (String str : ((Command)cmd).callDescriptor()) {
            this._module.println("%a", str);
        }
        this._module.endTable();
        return true;
    }
}

