/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.util.Pair;
import cora.rwinduction.command.Command;
import cora.rwinduction.command.ReductionCommandInherit;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.Hypothesis;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

abstract class HypothesisCommandInherit
extends ReductionCommandInherit {
    public HypothesisCommandInherit(String kind) {
        super(kind, "<name>[-inverse]");
    }

    @Override
    protected final void addTabSuggestionsForKind(TreeSet<FunctionSymbol> symbols, ArrayList<Command.TabSuggestion> suggestions) {
        for (Hypothesis hypo : this._proof.getProofState().getHypotheses()) {
            Equation eq = hypo.getEquation();
            if (!eq.getLhs().isFunctionalTerm() || symbols.contains(eq.getLhs().queryRoot())) {
                suggestions.add(new Command.TabSuggestion(hypo.getName(), "hypothesis"));
            }
            if (eq.getRhs().isFunctionalTerm() && !symbols.contains(eq.getRhs().queryRoot())) continue;
            suggestions.add(new Command.TabSuggestion(hypo.getName() + "-inverse", "hypothesis"));
        }
    }

    @Override
    protected final Term getLeftFor(String hypoDesc) {
        Pair<String, Boolean> pair = this.splitHypothesisName(hypoDesc);
        Hypothesis hypothesis = this._proof.getProofState().getHypothesisByName(pair.fst());
        if (hypothesis == null) {
            return null;
        }
        if (pair.snd().booleanValue()) {
            return hypothesis.getEquation().getRhs();
        }
        return hypothesis.getEquation().getLhs();
    }

    protected Pair<Hypothesis, Boolean> readHypothesis(CommandParsingStatus input) {
        String txt = input.nextWord();
        if (txt == null || txt.equals("")) {
            this._module.println("Command " + this._commandName + " should be invoked with at least 1 argument.", new Object[0]);
            return null;
        }
        Pair<String, Boolean> pair = this.splitHypothesisName(txt);
        String name = pair.fst();
        boolean inverse = pair.snd();
        Hypothesis hypo = this._proof.getProofState().getHypothesisByName(name);
        if (hypo == null) {
            this._module.println("No such induction hypothesis: %a.", name);
            return null;
        }
        return new Pair<Hypothesis, Boolean>(hypo, inverse);
    }

    private Pair<String, Boolean> splitHypothesisName(String txt) {
        int len = txt.length();
        for (String str : List.of("^{-1}", "-inverse")) {
            int strlen = str.length();
            if (len <= strlen || !txt.substring(len - strlen).equals(str)) continue;
            return new Pair<String, Boolean>(txt.substring(0, len - strlen), true);
        }
        return new Pair<String, Boolean>(txt, false);
    }
}

