/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.substitution.Matcher;
import charlie.substitution.MutableSubstitution;
import charlie.substitution.Substitution;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.position.Position;
import charlie.terms.position.PositionFormatException;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.util.FixedList;
import charlie.util.Pair;
import cora.rwinduction.command.Command;
import cora.rwinduction.command.DeductionCommand;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationPosition;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.ArrayList;
import java.util.TreeSet;

abstract class ReductionCommandInherit
extends DeductionCommand {
    protected String _commandName;
    private String _reducibleKind;

    protected ReductionCommandInherit(String cmdName, String kind) {
        this._commandName = cmdName;
        this._reducibleKind = kind;
    }

    @Override
    public final String queryName() {
        return this._commandName;
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of(this._commandName, this._commandName + " " + this._reducibleKind, this._commandName + " " + this._reducibleKind + " <position>", this._commandName + " " + this._reducibleKind + " with <substitution>", this._commandName + " " + this._reducibleKind + " <position> with <substitution>");
    }

    public ArrayList<Command.TabSuggestion> suggestNext(String args) {
        ArrayList<Command.TabSuggestion> ret = new ArrayList<Command.TabSuggestion>();
        TreeSet<FunctionSymbol> symbols = this.existingSymbols();
        String[] parts = args.split("\\s+");
        if (parts.length == 0 || parts[0].equals("")) {
            this.addTabSuggestionsForKind(symbols, ret);
            ret.add(this.endOfCommandSuggestion());
            return ret;
        }
        Term left = this.getLeftFor(parts[0]);
        if (left == null) {
            return ret;
        }
        if (parts.length == 1) {
            this.storePositionSuggestions(left, ret, EquationPosition.Side.Left, this._proof.getProofState().getTopEquation().getEquation().getLhs());
            this.storePositionSuggestions(left, ret, EquationPosition.Side.Right, this._proof.getProofState().getTopEquation().getEquation().getRhs());
            return ret;
        }
        if (parts.length == 2 && !parts[1].equals("with")) {
            ret.add(new Command.TabSuggestion("with", "keyword"));
            ret.add(this.endOfCommandSuggestion());
            return ret;
        }
        if (parts.length >= 3 && !parts[1].equals("with") && !parts[2].equals("with")) {
            return ret;
        }
        String last = parts[parts.length - 1];
        if (!last.equals("") && last.charAt(last.length() - 1) == ']') {
            ret.add(this.endOfCommandSuggestion());
        } else {
            ret.add(new Command.TabSuggestion(null, "substitution"));
        }
        return ret;
    }

    private TreeSet<FunctionSymbol> existingSymbols() {
        TreeSet<FunctionSymbol> ret = new TreeSet<FunctionSymbol>();
        if (this._proof.getProofState().isFinalState()) {
            return ret;
        }
        Equation eq = this._proof.getProofState().getTopEquation().getEquation();
        eq.getLhs().storeFunctionSymbols(ret);
        eq.getRhs().storeFunctionSymbols(ret);
        return ret;
    }

    protected abstract void addTabSuggestionsForKind(TreeSet<FunctionSymbol> var1, ArrayList<Command.TabSuggestion> var2);

    protected abstract Term getLeftFor(String var1);

    private void storePositionSuggestions(Term leftOfReducer, ArrayList<Command.TabSuggestion> suggestions, EquationPosition.Side side, Term term) {
        Printer printer = PrinterFactory.createParseablePrinter(this._proof.getContext().getTRS());
        term.visitSubterms((s, p) -> {
            if (Matcher.match(leftOfReducer, s) != null) {
                EquationPosition pos = new EquationPosition(side, (Position)p);
                pos.print(printer);
                suggestions.add(new Command.TabSuggestion(printer.toString(), "position"));
                printer.clear();
            }
        });
    }

    protected Pair<EquationPosition, Substitution> readCommandRemainder(Renaming kindRenaming, CommandParsingStatus input) {
        Substitution subst;
        String arg = input.nextWord();
        EquationPosition pos = this.readEquationPos(arg);
        if (pos == null) {
            return null;
        }
        if (arg != null && !arg.equals("with")) {
            arg = input.nextWord();
        }
        if (arg == null) {
            subst = new MutableSubstitution();
        } else {
            if (!arg.equals("with")) {
                this._module.println("Unexpected argument at position %a: expected \"with\" or end of command, but got %a.", input.previousPosition(), arg);
                return null;
            }
            subst = this.readSubstitution(input, kindRenaming);
            if (subst == null) {
                return null;
            }
        }
        if (!this.verifyEnded(input)) {
            return null;
        }
        return new Pair<EquationPosition, Substitution>(pos, subst);
    }

    private EquationPosition readEquationPos(String input) {
        if (input == null || input.equals("with")) {
            return EquationPosition.TOPLEFT;
        }
        try {
            EquationPosition ret = EquationPosition.parse(input);
            if (ret != null) {
                return ret;
            }
            this._module.println("Unexpected argument %a: I expected a valid position (or \"with\").\n\n", input);
        }
        catch (PositionFormatException e) {
            this._module.println("Illegal position %a (character %a): %a", input, e.queryProblemPos(), e.queryExplanation());
        }
        return null;
    }

    private Substitution readSubstitution(CommandParsingStatus input, Renaming keyNames) {
        if (this._proof.getProofState().isFinalState()) {
            this._module.println("The proof state is empty; there is nothing to reduce.", new Object[0]);
            return null;
        }
        MutableRenaming valueNames = this._proof.getProofState().getTopEquation().getRenaming().copy();
        return input.readSubstitution(this._proof.getContext().getTRS(), keyNames, valueNames, this._module);
    }
}

