/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine;

import cora.io.OutputModule;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.Optional;

public abstract class DeductionStep {
    protected final ProofState _state;
    protected final EquationContext _equ;
    protected final ProofContext _pcontext;

    protected DeductionStep(ProofState state, ProofContext context) {
        this._state = state;
        this._pcontext = context;
        this._equ = state.getTopEquation();
    }

    public abstract boolean verify(Optional<OutputModule> var1);

    public final boolean execute(PartialProof proof, Optional<OutputModule> o) {
        if (proof.isFinal()) {
            return this.println(o, "The proof is already finished.", new Object[0]);
        }
        if (proof.getProofState() != this._state) {
            return this.println(o, "Cannot apply step to different state.", new Object[0]);
        }
        try {
            ProofState newstate = this.tryApply(o);
            if (newstate == null) {
                return false;
            }
            proof.addProofStep(newstate, this);
            return true;
        }
        catch (RuntimeException e) {
            this.println(o, "Error applying step: %a", e.getMessage());
            return false;
        }
    }

    public final boolean verifyAndExecute(PartialProof proof, Optional<OutputModule> o) {
        return this.verify(o) && this.execute(proof, o);
    }

    protected abstract ProofState tryApply(Optional<OutputModule> var1);

    protected final boolean println(Optional<OutputModule> module, String str, Object ... objects) {
        module.ifPresent(o -> o.println(str, objects));
        return false;
    }

    public final ProofState getOriginalState() {
        return this._state;
    }

    public abstract String commandDescription();

    public abstract void explain(OutputModule var1);

    public final String toString() {
        return this.commandDescription();
    }

    public static EquationContext getTopEquation(ProofState state, Optional<OutputModule> module) {
        if (state.isFinalState()) {
            module.ifPresent(o -> o.println("The proof is already complete.", new Object[0]));
            return null;
        }
        return state.getTopEquation();
    }
}

