/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine;

import charlie.printer.PrintableObject;
import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.InvalidPositionException;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import charlie.terms.replaceable.Renaming;
import cora.rwinduction.engine.EquationPosition;

public final class Equation {
    private Term _lhs;
    private Term _rhs;
    private Term _constraint;

    public Equation(Term lhs, Term rhs, Term constraint) {
        this._lhs = lhs;
        this._rhs = rhs;
        this._constraint = constraint;
    }

    public Equation(Term lhs, Term rhs) {
        this._lhs = lhs;
        this._rhs = rhs;
        this._constraint = TheoryFactory.createValue(true);
    }

    public Term getLhs() {
        return this._lhs;
    }

    public Term getRhs() {
        return this._rhs;
    }

    public Term getConstraint() {
        return this._constraint;
    }

    public boolean isConstrained() {
        if (this._constraint.toValue() == null) {
            return true;
        }
        return !this._constraint.toValue().getBool();
    }

    public Term querySubterm(EquationPosition pos) {
        Term t = pos.querySide() == EquationPosition.Side.Left ? this._lhs : this._rhs;
        try {
            return t.querySubterm(pos.queryPosition());
        }
        catch (InvalidPositionException e) {
            return null;
        }
    }

    public Equation replaceSubterm(EquationPosition pos, Term replacement) {
        return switch (pos.querySide()) {
            default -> throw new MatchException(null, null);
            case EquationPosition.Side.Left -> {
                Term l = this._lhs.replaceSubterm(pos.queryPosition(), replacement);
                yield new Equation(l, this._rhs, this._constraint);
            }
            case EquationPosition.Side.Right -> {
                Term r = this._rhs.replaceSubterm(pos.queryPosition(), replacement);
                yield new Equation(this._lhs, r, this._constraint);
            }
        };
    }

    void printWithRenaming(Printer printer, Renaming renaming) {
        Object[] objectArray = new Object[5];
        objectArray[0] = Printer.makePrintable(this._lhs, renaming);
        objectArray[1] = " ";
        objectArray[2] = printer.symbApprox();
        objectArray[3] = " ";
        objectArray[4] = Printer.makePrintable(this._rhs, renaming);
        printer.add(objectArray);
        if (this.isConstrained()) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = " | ";
            objectArray2[1] = Printer.makePrintable(this._constraint, renaming);
            printer.add(objectArray2);
        }
    }

    public PrintableObject makePrintableWith(final Renaming renaming) {
        return new PrintableObject(){

            @Override
            public void print(Printer printer) {
                Equation.this.printWithRenaming(printer, renaming);
            }
        };
    }

    public String toString() {
        Printer printer = PrinterFactory.createPrinterNotForUserOutput();
        printer.add(this._lhs, " ", printer.symbApprox(), " ", this._rhs, " | ", this._constraint);
        return printer.toString();
    }
}

