/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine;

import charlie.printer.PrintableObject;
import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.Term;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.terms.replaceable.ReplaceableList;
import cora.io.OutputModule;
import cora.rwinduction.engine.Equation;
import java.util.Optional;

public class EquationContext
implements PrintableObject {
    private Equation _equation;
    private Optional<Term> _leftGeq;
    private Optional<Term> _rightGeq;
    private Renaming _varNaming;
    private int _index;

    public EquationContext(Term leftgr, Equation equation, Term rightgr, int index, Renaming naming) {
        this._equation = equation;
        this._leftGeq = Optional.of(leftgr);
        this._rightGeq = Optional.of(rightgr);
        this._index = index;
        MutableRenaming varnaming = naming.copy();
        varnaming.limitDomain(leftgr.freeReplaceables(), rightgr.freeReplaceables(), this._equation.getLhs().freeReplaceables(), this._equation.getRhs().freeReplaceables(), this._equation.getConstraint().freeReplaceables());
        this._varNaming = varnaming.makeImmutable();
        this.checkReplaceableNaming();
        this.checkIndex();
    }

    public EquationContext(Equation equation, int index, Renaming naming) {
        this._equation = equation;
        this._leftGeq = Optional.empty();
        this._rightGeq = Optional.empty();
        this._index = index;
        MutableRenaming varnaming = naming.copy();
        varnaming.limitDomain(this._equation.getLhs().freeReplaceables(), this._equation.getRhs().freeReplaceables(), this._equation.getConstraint().freeReplaceables());
        this._varNaming = varnaming.makeImmutable();
        this.checkReplaceableNaming();
        this.checkIndex();
    }

    public EquationContext(Optional<Term> leftgr, Equation equation, Optional<Term> rightgr, int index, Renaming naming) {
        this._equation = equation;
        this._leftGeq = leftgr;
        this._rightGeq = rightgr;
        this._index = index;
        MutableRenaming varnaming = naming.copy();
        varnaming.limitDomain(leftgr.isEmpty() ? ReplaceableList.EMPTY : leftgr.get().freeReplaceables(), this._equation.getLhs().freeReplaceables(), this._equation.getRhs().freeReplaceables(), this._equation.getConstraint().freeReplaceables(), rightgr.isEmpty() ? ReplaceableList.EMPTY : rightgr.get().freeReplaceables());
        this._varNaming = varnaming.makeImmutable();
        this.checkReplaceableNaming();
        this.checkIndex();
    }

    private void checkReplaceableNaming() {
        this.checkReplaceablesIn(this._equation.getLhs(), "equation's left-hand side");
        this.checkReplaceablesIn(this._equation.getRhs(), "equation's right-hand side");
        this.checkReplaceablesIn(this._equation.getConstraint(), "constraint of the equation");
        this._leftGeq.ifPresent(t -> this.checkReplaceablesIn((Term)t, "left comparison term of equation context"));
        this._rightGeq.ifPresent(t -> this.checkReplaceablesIn((Term)t, "right comparison term of equation context"));
    }

    private void checkReplaceablesIn(Term t, String location) {
        for (Replaceable x : t.freeReplaceables()) {
            if (this._varNaming.getName(x) != null) continue;
            throw new IllegalArgumentException("Unknown replaceable in " + location + ": " + String.valueOf(x));
        }
    }

    private void checkIndex() {
        if (this._index <= 0) {
            throw new IllegalArgumentException("Equation context " + this.toString() + " given index " + this._index + "; all indexes must be > 0.");
        }
    }

    public Equation getEquation() {
        return this._equation;
    }

    public boolean hasExtraTerms() {
        return !this._leftGeq.isEmpty() || !this._rightGeq.isEmpty();
    }

    public Optional<Term> getLeftGreaterTerm() {
        return this._leftGeq;
    }

    public Optional<Term> getRightGreaterTerm() {
        return this._rightGeq;
    }

    public Term getLhs() {
        return this._equation.getLhs();
    }

    public Term getRhs() {
        return this._equation.getRhs();
    }

    public Term getConstraint() {
        return this._equation.getConstraint();
    }

    public int getIndex() {
        return this._index;
    }

    public String getName() {
        return "E" + this.getIndex();
    }

    public Renaming getRenaming() {
        return this._varNaming;
    }

    public EquationContext replace(Equation eq, int index) {
        return new EquationContext(this._leftGeq, eq, this._rightGeq, index, this._varNaming);
    }

    public EquationContext replace(Equation eq, Renaming naming, int index) {
        return new EquationContext(this._leftGeq, eq, this._rightGeq, index, naming);
    }

    @Override
    public void print(Printer p) {
        Object[] objectArray = new Object[8];
        objectArray[0] = this.getName();
        objectArray[1] = ": (";
        objectArray[2] = this._leftGeq.isEmpty() ? p.symbBullet() : Printer.makePrintable(this._leftGeq.get(), this._varNaming);
        objectArray[3] = " , ";
        objectArray[4] = this._equation.makePrintableWith(this._varNaming);
        objectArray[5] = " , ";
        objectArray[6] = this._rightGeq.isEmpty() ? p.symbBullet() : Printer.makePrintable(this._rightGeq.get(), this._varNaming);
        objectArray[7] = ")";
        p.add(objectArray);
    }

    public void prettyPrint(OutputModule module, boolean useColour) {
        String yellow = useColour ? "\u001b[1;33m" : "";
        String red = useColour ? "\u001b[1;31m" : "";
        String reset = useColour ? "\u001b[0m" : "";
        Object l = "";
        Object r = "";
        if (this._leftGeq.isPresent() && this._leftGeq.get().equals(this._equation.getLhs())) {
            l = red + " \u29be" + reset;
        }
        if (this._rightGeq.isPresent() && this._rightGeq.get().equals(this._equation.getRhs())) {
            r = red + " \u29be" + reset;
        }
        module.print("%a%a %a%{approx}%a %a%a", Printer.makePrintable(this._equation.getLhs(), this._varNaming), l, yellow, reset, Printer.makePrintable(this._equation.getRhs(), this._varNaming), r);
        if (this._equation.isConstrained()) {
            module.print(" %a|%a %a", yellow, reset, Printer.makePrintable(this._equation.getConstraint(), this._varNaming));
        }
    }

    public String toString() {
        Printer printer = PrinterFactory.createPrinterNotForUserOutput();
        printer.add(this);
        return printer.toString();
    }
}

