/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine;

import charlie.printer.PrintableObject;
import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.position.Position;
import charlie.terms.position.PositionFormatException;

public class EquationPosition
implements PrintableObject {
    public static EquationPosition TOPLEFT = new EquationPosition(Side.Left, Position.empty);
    public static EquationPosition TOPRIGHT = new EquationPosition(Side.Right, Position.empty);
    private Side _side;
    private Position _position;

    public EquationPosition(Side side, Position pos) {
        this._side = side;
        this._position = pos;
    }

    public EquationPosition(Side side) {
        this._side = side;
        this._position = Position.empty;
    }

    public Side querySide() {
        return this._side;
    }

    public Position queryPosition() {
        return this._position;
    }

    @Override
    public void print(Printer printer) {
        String s;
        switch (this._side.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                String string = "l";
                break;
            }
            case 1: {
                String string = s = "r";
            }
        }
        if (this._position.isEmpty()) {
            printer.add(s);
        } else if (this._position.isFinal()) {
            printer.add(s, ".", this._position);
        } else {
            printer.add(s, this._position);
        }
    }

    public String toString() {
        Printer printer = PrinterFactory.createPrinterNotForUserOutput();
        this.print(printer);
        return printer.toString();
    }

    public boolean equals(EquationPosition other) {
        return this._side.equals((Object)other._side) && this._position.equals(other._position);
    }

    public boolean equals(Object other) {
        if (other instanceof EquationPosition) {
            EquationPosition pos = (EquationPosition)other;
            return this.equals(pos);
        }
        return false;
    }

    public static EquationPosition parse(String desc) throws PositionFormatException {
        if ((desc = desc.trim()).equals("") || desc.equals("l")) {
            return TOPLEFT;
        }
        if (desc.equals("r")) {
            return TOPRIGHT;
        }
        Side side = Side.Left;
        int extra = 0;
        if (desc.charAt(0) == 'l') {
            desc = desc.substring(1);
            extra = 1;
        } else if (desc.charAt(0) == 'r') {
            desc = desc.substring(1);
            side = Side.Right;
            extra = 1;
        }
        try {
            Position pos = Position.parse(desc);
            return new EquationPosition(side, pos);
        }
        catch (PositionFormatException e) {
            throw new PositionFormatException(e.queryProblemPos() + extra, desc, e.queryExplanation());
        }
    }

    public static enum Side {
        Left,
        Right;

    }
}

