/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine;

import charlie.printer.PrintableObject;
import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.Term;
import charlie.terms.replaceable.Renaming;
import cora.rwinduction.engine.Equation;

public class Hypothesis
implements PrintableObject {
    private Equation _equation;
    private Renaming _varNaming;
    private int _index;

    public Hypothesis(Equation equation, int index, Renaming naming) {
        this._equation = equation;
        this._index = index;
        this._varNaming = naming.makeImmutable();
    }

    public Equation getEquation() {
        return this._equation;
    }

    public Term getLhs() {
        return this._equation.getLhs();
    }

    public Term getRhs() {
        return this._equation.getRhs();
    }

    public Term getConstraint() {
        return this._equation.getConstraint();
    }

    public int getIndex() {
        return this._index;
    }

    public String getName() {
        return "H" + this.getIndex();
    }

    public Renaming getRenaming() {
        return this._varNaming;
    }

    @Override
    public void print(Printer printer) {
        printer.add(this.getName(), ": ");
        this._equation.printWithRenaming(printer, this._varNaming);
    }

    public String toString() {
        Printer printer = PrinterFactory.createPrinterNotForUserOutput();
        this.print(printer);
        return printer.toString();
    }
}

