/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine;

import charlie.printer.PrintableObject;
import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import charlie.terms.replaceable.Renaming;

public class OrdReq
implements PrintableObject {
    private Term _lhs;
    private Term _rhs;
    private Term _constraint;
    private boolean _strict;
    private Renaming _renaming;

    public OrdReq(Term left, Term right, Term constraint, Renaming renaming) {
        this._lhs = left;
        this._rhs = right;
        this._constraint = constraint;
        this._strict = true;
        this._renaming = renaming.makeImmutable();
    }

    public OrdReq(Term left, Term right, Term constraint, Renaming renaming, boolean strict) {
        this._lhs = left;
        this._rhs = right;
        this._constraint = constraint;
        this._strict = strict;
        this._renaming = renaming.makeImmutable();
    }

    public Term getLhs() {
        return this._lhs;
    }

    public Term getRhs() {
        return this._rhs;
    }

    public Term getConstraint() {
        return this._constraint;
    }

    public Renaming queryRenaming() {
        return this._renaming;
    }

    @Override
    public void print(Printer printer) {
        Object[] objectArray = new Object[5];
        objectArray[0] = Printer.makePrintable(this._lhs, this._renaming);
        objectArray[1] = " ";
        objectArray[2] = this._strict ? printer.symbSucc() : printer.symbSucceq();
        objectArray[3] = " ";
        objectArray[4] = Printer.makePrintable(this._rhs, this._renaming);
        printer.add(objectArray);
        if (!this._constraint.equals(TheoryFactory.trueValue)) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = " | ";
            objectArray2[1] = Printer.makePrintable(this._constraint, this._renaming);
            printer.add(objectArray2);
        }
    }

    public String toString() {
        Printer printer = PrinterFactory.createPrinterNotForUserOutput();
        this.print(printer);
        return printer.toString();
    }
}

