/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine;

import charlie.terms.Term;
import charlie.terms.replaceable.Renaming;
import charlie.trs.TRS;
import charlie.util.FixedList;
import charlie.util.NullStorageException;
import cora.io.ProofObject;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;

public class PartialProof {
    private final ProofContext _pcontext;
    private final Stack<ProofState> _previousStates = new Stack();
    private final Stack<ProofState> _futureStates = new Stack();
    private final Stack<DeductionStep> _previousCommands = new Stack();
    private final Stack<DeductionStep> _futureCommands = new Stack();
    private ProofState _currentState;
    private boolean _aborted;
    private ProofObject _finished;

    public PartialProof(TRS initialSystem, FixedList<EquationContext> initialEquations, Function<List<Term>, Renaming> renamingMaker) {
        if (initialEquations == null) {
            throw new NullStorageException("PartialProof", "initial eqs");
        }
        this._pcontext = new ProofContext(initialSystem, renamingMaker);
        this._currentState = new ProofState(initialEquations);
        this._aborted = false;
        this._finished = null;
    }

    public ProofContext getContext() {
        return this._pcontext;
    }

    public ProofState getProofState() {
        return this._currentState;
    }

    public boolean isDone() {
        return this._aborted || this._finished != null;
    }

    public boolean isFinal() {
        return this._currentState.isFinalState();
    }

    public void abort() {
        this._aborted = true;
    }

    public void finish(ProofObject terminationProof) {
        if (!this._currentState.isFinalState()) {
            throw new RuntimeException("Calling finish when the last proof state is not final!");
        }
        this._finished = terminationProof;
    }

    public void addProofStep(ProofState proofState, DeductionStep step) {
        this._previousStates.push(this._currentState);
        this._previousCommands.push(step);
        this._currentState = proofState;
        this._futureStates.clear();
        this._futureCommands.clear();
    }

    public boolean undoProofStep() {
        if (this._previousStates.isEmpty()) {
            return false;
        }
        this._futureStates.push(this._currentState);
        this._futureCommands.push(this._previousCommands.pop());
        this._currentState = this._previousStates.pop();
        return true;
    }

    public boolean redoProofStep() {
        if (this._futureStates.isEmpty()) {
            return false;
        }
        this._previousStates.push(this._currentState);
        this._previousCommands.push(this._futureCommands.pop());
        this._currentState = this._futureStates.pop();
        return true;
    }

    public ArrayList<String> getCommandHistory() {
        ArrayList<String> ret = new ArrayList<String>(this._previousCommands.size());
        for (DeductionStep step : this._previousCommands) {
            ret.add(step.commandDescription());
        }
        return ret;
    }

    public ArrayList<DeductionStep> getDeductionHistory() {
        return new ArrayList<DeductionStep>(this._previousCommands);
    }

    public ProofObject getTerminationProof() {
        return this._finished;
    }
}

