/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine;

import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.Variable;
import charlie.terms.replaceable.Renaming;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.types.Type;
import charlie.util.NullStorageException;
import charlie.util.Pair;
import cora.rwinduction.engine.VariableNamer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;

public class ProofContext {
    private final TRS _trs;
    private final ArrayList<String> _ruleNames = new ArrayList();
    private final ArrayList<Renaming> _ruleRenamings = new ArrayList();
    private final HashMap<String, Integer> _nameToRule = new HashMap();
    private final HashMap<Type, Set<FunctionSymbol>> _constructors = new HashMap();
    private final HashMap<FunctionSymbol, Integer> _arities = new HashMap();
    private final HashMap<FunctionSymbol, Set<String>> _rulesBySymbol = new HashMap();
    private VariableNamer _namer;

    public ProofContext(TRS initialSystem, Function<List<Term>, Renaming> renamingMaker) {
        if (initialSystem == null) {
            throw new NullStorageException("ProofContext", "initial TRS");
        }
        this._trs = initialSystem;
        int n = initialSystem.queryRuleCount();
        this.createRuleInfo(renamingMaker);
        this.createConstructorInfo();
        this._namer = new VariableNamer(this.createNamingInfo());
    }

    private void createRuleInfo(Function<List<Term>, Renaming> renamingMaker) {
        for (int i = 0; i < this._trs.queryRuleCount(); ++i) {
            Rule rule = this._trs.queryRule(i);
            Renaming renaming = renamingMaker.apply(List.of(rule.queryLeftSide(), rule.queryRightSide(), rule.queryConstraint())).makeImmutable();
            String name = "R" + (i + 1);
            this._ruleNames.add(name);
            this._nameToRule.put(name, i);
            this._ruleRenamings.add(renaming);
            if (!rule.queryLeftSide().isFunctionalTerm()) continue;
            FunctionSymbol f = rule.queryLeftSide().queryRoot();
            if (!this._arities.containsKey(f)) {
                this._arities.put(f, rule.queryLeftSide().numberArguments());
            }
            if (!this._rulesBySymbol.containsKey(f)) {
                this._rulesBySymbol.put(f, new TreeSet());
            }
            this._rulesBySymbol.get(f).add(name);
        }
        for (FunctionSymbol f : this._rulesBySymbol.keySet()) {
            this._rulesBySymbol.put(f, Collections.unmodifiableSet(this._rulesBySymbol.get(f)));
        }
    }

    private void createConstructorInfo() {
        for (FunctionSymbol f : this._trs.queryAlphabet().getSymbols()) {
            if (this._trs.isDefined(f) || f.isTheorySymbol()) continue;
            Type t = f.queryType().queryOutputType();
            Set<FunctionSymbol> set = this._constructors.get(t);
            if (set == null) {
                set = new TreeSet<FunctionSymbol>();
                this._constructors.put(t, set);
            }
            set.add(f);
        }
        for (Type t : this._constructors.keySet()) {
            this._constructors.put(t, Collections.unmodifiableSet(this._constructors.get(t)));
        }
    }

    private ArrayList<Pair<Pair<FunctionSymbol, Integer>, String>> createNamingInfo() {
        ArrayList<Pair<Pair<FunctionSymbol, Integer>, String>> ret = new ArrayList<Pair<Pair<FunctionSymbol, Integer>, String>>();
        for (int i = 0; i < this._trs.queryRuleCount(); ++i) {
            Renaming renaming = this._ruleRenamings.get(i);
            this._trs.queryRule(i).queryLeftSide().visitSubterms((s, p) -> this.addSubtermInfo(ret, (Term)s, renaming));
        }
        return ret;
    }

    private void addSubtermInfo(ArrayList<Pair<Pair<FunctionSymbol, Integer>, String>> info, Term s, Renaming renaming) {
        if (!s.isFunctionalTerm() || s.numberArguments() == 0) {
            return;
        }
        for (int j = 1; j <= s.numberArguments(); ++j) {
            if (!s.queryArgument(j).isVariable()) continue;
            Variable x = s.queryArgument(j).queryVariable();
            String name = renaming.getName(x);
            if (name == null || x.queryName().length() < name.length() && name.substring(0, x.queryName().length()).equals(x.queryName())) {
                name = x.queryName();
            }
            Pair<FunctionSymbol, Integer> pair = new Pair<FunctionSymbol, Integer>(s.queryRoot(), j);
            info.add(new Pair<Pair<FunctionSymbol, Integer>, String>(pair, name));
        }
    }

    public TRS getTRS() {
        return this._trs;
    }

    public String getRuleName(int index) {
        return this._ruleNames.get(index);
    }

    public boolean hasRule(String name) {
        return this._nameToRule.containsKey(name);
    }

    public Rule getRule(String name) {
        Integer i = this._nameToRule.get(name);
        if (i == null) {
            return null;
        }
        return this._trs.queryRule(i);
    }

    public Renaming getRenaming(String ruleName) {
        Integer i = this._nameToRule.get(ruleName);
        if (i == null) {
            return null;
        }
        return this._ruleRenamings.get(i);
    }

    public Set<FunctionSymbol> getConstructors(Type type) {
        Set<FunctionSymbol> ret = this._constructors.get(type);
        if (ret == null) {
            return Set.of();
        }
        return ret;
    }

    public int queryRuleArity(FunctionSymbol symbol) {
        if (this._arities.containsKey(symbol)) {
            return this._arities.get(symbol);
        }
        if (symbol.isTheorySymbol() && !symbol.isValue()) {
            return symbol.queryArity();
        }
        return symbol.queryArity() + 1;
    }

    public Set<String> queryRuleNamesByFunction(FunctionSymbol symbol) {
        return this._rulesBySymbol.get(symbol);
    }

    public VariableNamer getVariableNamer() {
        return this._namer;
    }
}

