/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine;

import charlie.util.FixedList;
import charlie.util.FixedSet;
import charlie.util.NullStorageException;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.Hypothesis;
import cora.rwinduction.engine.OrdReq;
import java.util.Iterator;
import java.util.List;

public class ProofState {
    private final FixedList<EquationContext> _equations;
    private final FixedList<Hypothesis> _hypotheses;
    private final FixedList<OrdReq> _ordering;
    private final FixedSet<Integer> _incomplete;
    private final int _lastUsedIndex;
    private final boolean _contradiction;

    public ProofState(FixedList<EquationContext> initialEquations) {
        if (initialEquations == null) {
            throw new NullStorageException("ProofState", "initialEquations cannot be null");
        }
        this._equations = initialEquations;
        this._hypotheses = FixedList.of();
        this._ordering = FixedList.of();
        this._contradiction = false;
        int largest = 0;
        for (EquationContext eq : initialEquations) {
            if (eq.getIndex() <= largest) continue;
            largest = eq.getIndex();
        }
        this._lastUsedIndex = largest;
        this._incomplete = FixedSet.of();
    }

    public ProofState(FixedList<EquationContext> equations, FixedList<Hypothesis> hypotheses, FixedList<OrdReq> ordering, FixedSet<Integer> incomplete, int lastIndex) {
        if (equations == null || hypotheses == null || ordering == null) {
            throw new NullStorageException("ProofState", "one of the arguments in full constructor");
        }
        this._equations = equations;
        this._hypotheses = hypotheses;
        this._ordering = ordering;
        this._lastUsedIndex = lastIndex;
        this._incomplete = incomplete;
        this._contradiction = false;
    }

    private ProofState() {
        this._equations = FixedList.of();
        this._hypotheses = FixedList.of();
        this._ordering = FixedList.of();
        this._incomplete = FixedSet.of();
        this._lastUsedIndex = 0;
        this._contradiction = true;
    }

    public static ProofState getContradictionState() {
        return new ProofState();
    }

    public FixedList<EquationContext> getEquations() {
        return this._equations;
    }

    public FixedList<Hypothesis> getHypotheses() {
        return this._hypotheses;
    }

    public FixedList<OrdReq> getOrderingRequirements() {
        return this._ordering;
    }

    public FixedSet<Integer> getIncompleteEquations() {
        return this._incomplete;
    }

    public int getLastUsedIndex() {
        return this._lastUsedIndex;
    }

    public EquationContext getTopEquation() {
        return this._equations.get(this._equations.size() - 1);
    }

    public Hypothesis getHypothesisByName(String name) {
        for (Hypothesis h : this._hypotheses) {
            if (!h.getName().equals(name)) continue;
            return h;
        }
        return null;
    }

    public ProofState addEquation(EquationContext context) {
        int last = context.getIndex() > this._lastUsedIndex ? context.getIndex() : this._lastUsedIndex;
        FixedSet<Integer> inc = this._incomplete;
        if (!this._incomplete.isEmpty()) {
            inc = inc.add(context.getIndex());
        }
        return new ProofState(this._equations.append((EquationContext)((Object)List.of(context))), this._hypotheses, this._ordering, inc, last);
    }

    public ProofState replaceTopEquation(EquationContext newData) {
        return this.replaceTopEquation(List.of(newData));
    }

    public ProofState replaceTopEquation(List<EquationContext> newData) {
        int last = this._lastUsedIndex;
        if (this._equations.isEmpty()) {
            throw new IndexOutOfBoundsException("ProofState::replaceTopEquation() called when the set of equations is empty!");
        }
        FixedList.Builder<EquationContext> lst = new FixedList.Builder<EquationContext>(this._equations.size() + newData.size() - 1);
        for (int i = 0; i < this._equations.size() - 1; ++i) {
            lst.add(this._equations.get(i));
        }
        for (EquationContext e : newData) {
            if (e.getIndex() > last) {
                last = e.getIndex();
            }
            lst.add(e);
        }
        FixedSet<Integer> inc = this._incomplete;
        if (!inc.isEmpty()) {
            FixedSet.Builder<Integer> newinc = FixedSet.treeBuilder();
            int replace = this._equations.get(this._equations.size() - 1).getIndex();
            Iterator<Object> iterator = this._incomplete.iterator();
            while (iterator.hasNext()) {
                int k = iterator.next();
                if (k == replace) continue;
                newinc.add(k);
            }
            for (EquationContext ec : newData) {
                newinc.add(ec.getIndex());
            }
            inc = newinc.build();
        }
        return new ProofState(lst.build(), this._hypotheses, this._ordering, inc, last);
    }

    public ProofState deleteTopEquation() {
        return this.replaceTopEquation(List.of());
    }

    public ProofState addHypothesis(Hypothesis hypothesis) {
        int last = this._lastUsedIndex;
        if (hypothesis.getIndex() > last) {
            last = hypothesis.getIndex();
        }
        return new ProofState(this._equations, this._hypotheses.append((Hypothesis)((Object)List.of(hypothesis))), this._ordering, this._incomplete, last);
    }

    public ProofState addOrderingRequirement(OrdReq ordreq) {
        return new ProofState(this._equations, this._hypotheses, this._ordering.append((OrdReq)((Object)List.of(ordreq))), this._incomplete, this._lastUsedIndex);
    }

    public ProofState setIncomplete(int equationIndex) {
        if (this._incomplete.contains(equationIndex)) {
            return this;
        }
        return new ProofState(this._equations, this._hypotheses, this._ordering, this._incomplete.add(equationIndex), this._lastUsedIndex);
    }

    public boolean isFinalState() {
        return this._equations.isEmpty();
    }

    public boolean isContradictionState() {
        return this._contradiction;
    }

    public String toString() {
        if (this._contradiction) {
            return "CONTRADICTION";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Equations:\n");
        for (EquationContext eq : this._equations) {
            if (this._incomplete.contains(eq.getIndex())) {
                builder.append(" " + eq.toString() + "  -- INCOMPLETE\n");
                continue;
            }
            builder.append(" " + eq.toString() + "\n");
        }
        if (!this._hypotheses.isEmpty()) {
            builder.append("Induction hypotheses:\n");
        }
        for (Hypothesis hy : this._hypotheses) {
            builder.append(" " + hy.toString() + "\n");
        }
        if (!this._ordering.isEmpty()) {
            builder.append("Ordering requirements:\n");
        }
        for (OrdReq req : this._ordering) {
            builder.append(" * " + req.toString() + "\n");
        }
        return builder.toString();
    }
}

