/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine;

import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.Variable;
import charlie.terms.replaceable.MutableRenaming;
import charlie.types.Type;
import charlie.util.Pair;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class VariableNamer {
    private TreeMap<String, String> _defaultNames;

    VariableNamer(ArrayList<Pair<Pair<FunctionSymbol, Integer>, String>> info) {
        TreeMap usualNames = new TreeMap();
        for (Pair<Pair<FunctionSymbol, Integer>, String> pair : info) {
            int n;
            FunctionSymbol f = pair.fst().fst();
            int index = pair.fst().snd();
            String name = pair.snd();
            for (n = name.length(); n > 0 && Character.isDigit(name.charAt(n - 1)); --n) {
            }
            if (n == 0) continue;
            name = name.substring(0, n);
            String key = f.queryName() + ":" + index;
            if (!usualNames.containsKey(key)) {
                usualNames.put((CallSite)((Object)key), new TreeSet());
            }
            ((TreeSet)usualNames.get(key)).add(name);
        }
        this._defaultNames = new TreeMap();
        for (Map.Entry entry : usualNames.entrySet()) {
            if (((TreeSet)entry.getValue()).size() != 1) continue;
            this._defaultNames.put((String)entry.getKey(), (String)((TreeSet)entry.getValue()).first());
        }
    }

    public String queryDefaultNaming(FunctionSymbol f, int index) {
        return this._defaultNames.get(f.queryName() + ":" + index);
    }

    public VariableInfo getVariableInfo(String fullName) {
        int index;
        for (index = fullName.length(); index > 0 && Character.isDigit(fullName.charAt(index - 1)); --index) {
        }
        if (index == fullName.length()) {
            return new VariableInfo(fullName, 0);
        }
        int num = Integer.parseInt(fullName.substring(index));
        if (index == 0) {
            return new VariableInfo("var", num);
        }
        return new VariableInfo(fullName.substring(0, index), num);
    }

    public VariableInfo getVariableInfo(String baseName, String fullName) {
        if (fullName == null) {
            fullName = baseName;
        }
        VariableInfo ret = this.getVariableInfo(fullName);
        if (baseName.length() < ret.basename().length() && ret.basename().substring(0, baseName.length()).equals(baseName)) {
            return new VariableInfo(baseName, ret.index());
        }
        return ret;
    }

    public VariableInfo chooseDerivativeNaming(Variable x, MutableRenaming renaming) {
        String basename = x.queryName();
        String fullname = renaming.getName(x);
        if (fullname == null) {
            fullname = basename;
        }
        VariableInfo current = this.getVariableInfo(basename, fullname);
        int i = current.index + 1;
        String suggestedName;
        while (!renaming.isAvailable(suggestedName = current.basename() + i)) {
            ++i;
        }
        return new VariableInfo(current.basename(), i);
    }

    public VariableInfo chooseDerivativeNamingForTerm(Term t, MutableRenaming renaming, String defaultName) {
        TreeSet<Variable> set = this.getSuitableVariablesForDerivative(t);
        String base = null;
        if (set.size() > 0) {
            boolean first = true;
            for (Variable y : set) {
                VariableInfo info = this.getVariableInfo(y.queryName(), renaming.getName(y));
                if (first) {
                    first = false;
                    base = info.basename();
                    continue;
                }
                if (base.equals(info.basename())) continue;
                base = null;
                break;
            }
        }
        if (base == null) {
            base = defaultName;
        }
        int index = 1;
        for (Variable x : set) {
            VariableInfo info;
            String fullname = renaming.getName(x);
            if (fullname == null) {
                fullname = x.queryName();
            }
            if (!(info = this.getVariableInfo(base, fullname)).basename().equals(base) || info.index() < index) continue;
            index = info.index() + 1;
        }
        while (!renaming.isAvailable(base + index)) {
            ++index;
        }
        return new VariableInfo(base, index);
    }

    public TreeSet<Variable> getSuitableVariablesForDerivative(Term term) {
        TreeSet<Variable> set = new TreeSet<Variable>();
        for (Variable x : term.vars()) {
            if (!x.queryType().equals(term.queryType())) continue;
            set.add(x);
        }
        return set;
    }

    public Variable chooseDerivative(Variable x, MutableRenaming renaming, Type type) {
        VariableInfo info = this.chooseDerivativeNaming(x, renaming);
        Variable newvar = TermFactory.createVar(info.basename(), type);
        renaming.setName(newvar, info.basename() + info.index());
        return newvar;
    }

    public Variable chooseDerivativeOrSameNaming(Variable x, MutableRenaming renaming, Type type) {
        VariableInfo info = this.chooseDerivativeNaming(x, renaming);
        Variable newvar = TermFactory.createVar(info.basename(), type);
        if (renaming.getName(x) == null && renaming.getReplaceable(x.queryName()) == null && renaming.setName(newvar, x.queryName())) {
            return newvar;
        }
        renaming.setName(newvar, info.basename() + info.index());
        return newvar;
    }

    public Variable chooseDerivativeForTerm(Term t, MutableRenaming renaming, String defbase, Pair<FunctionSymbol, Integer> occursInside) {
        VariableInfo info;
        Variable x;
        String placename;
        if (occursInside != null && (placename = this.queryDefaultNaming(occursInside.fst(), occursInside.snd())) != null) {
            defbase = placename;
        }
        if (!renaming.setName(x = TermFactory.createVar((info = this.chooseDerivativeNamingForTerm(t, renaming, defbase)).basename(), t.queryType()), info.basename() + info.index())) {
            throw new RuntimeException("Unexpected behaviour in chooseDerivativeForTerm, name = " + info.basename() + info.index());
        }
        return x;
    }

    public record VariableInfo(String basename, int index) {
    }
}

