/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.automation;

import charlie.substitution.MutableSubstitution;
import charlie.substitution.Substitution;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import charlie.terms.position.ArgumentPos;
import charlie.terms.position.FinalPos;
import charlie.terms.position.Position;
import charlie.theorytranslation.TermAnalyser;
import charlie.util.Pair;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.EquationPosition;
import cora.rwinduction.engine.Hypothesis;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofState;
import cora.rwinduction.engine.deduction.DeductionDelete;
import cora.rwinduction.engine.deduction.DeductionDisproveRoot;
import cora.rwinduction.engine.deduction.DeductionDisproveTheory;
import cora.rwinduction.engine.deduction.DeductionEqdelete;
import cora.rwinduction.engine.deduction.DeductionHdelete;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class AutoDeleter {
    public static DeductionDelete tryPureDelete(PartialProof proof) {
        Optional<OutputModule> empty = Optional.empty();
        DeductionDelete ret = DeductionDelete.createStep(proof, empty);
        if (ret == null || !ret.verifyAndExecute(proof, empty)) {
            return null;
        }
        return ret;
    }

    public static DeductionStep createHdeleteStep(PartialProof proof, Optional<OutputModule> module) {
        EquationContext ec = proof.getProofState().getTopEquation();
        EndingStep step = AutoDeleter.seekHdelete(ec.getLhs(), ec.getRhs(), ec.getConstraint(), ec.getLeftGreaterTerm(), ec.getRightGreaterTerm(), proof.getProofState(), module);
        if (step == null) {
            return null;
        }
        return step.createStep(proof, module);
    }

    public static EndingStep seekHdelete(Term left, Term right, Term constraint, Optional<Term> leftbound, Optional<Term> rightbound, ProofState stateWithHypotheses, Optional<OutputModule> module) {
        if (leftbound.isPresent() && leftbound.get().equals(left) && rightbound.isPresent() && rightbound.get().equals(right)) {
            module.ifPresent(o -> o.println("No HDELETE step can be applied, because the bounding terms of the equation context are both equal to the corresponding side of the equation.  Hence, there is no way to apply HDELETE that would not lead to an unsatisfiable ordering requirement.", new Object[0]));
            return null;
        }
        ArrayList<Pair<Position, Pair<Term, Term>>> lst = AutoDeleter.contextDifferences(left, right);
        if (lst == null) {
            module.ifPresent(o -> o.println("The left- and right-hand side of the equation are the same.  I am using DELETE instead.", new Object[0]));
            return new DeleteStep();
        }
        for (Pair<Position, Pair<Term, Term>> pair : lst) {
            EndingStep ret = AutoDeleter.createHdeleteAtPosition(pair.fst(), pair.snd().fst(), pair.snd().snd(), constraint, leftbound, rightbound, stateWithHypotheses);
            if (ret == null) continue;
            return ret;
        }
        module.ifPresent(o -> o.println("There is no applicable position where we can clearly apply HDELETE with any available induction hypothesis.", new Object[0]));
        return null;
    }

    private static ArrayList<Pair<Position, Pair<Term, Term>>> contextDifferences(Term s, Term t) {
        int j;
        int i;
        ArrayList<Pair<Position, Pair<Term, Term>>> ret = null;
        if (!s.queryHead().equals(t.queryHead()) || s.numberArguments() != t.numberArguments()) {
            ret = new ArrayList<Pair<Position, Pair<Term, Term>>>();
            ret.add(new Pair<Position, Pair<Term, Term>>(Position.empty, new Pair<Term, Term>(s, t)));
            return ret;
        }
        int n = s.numberArguments();
        for (i = 1; i <= n && (ret = AutoDeleter.contextDifferences(s.queryArgument(i), t.queryArgument(i))) == null; ++i) {
        }
        if (ret == null) {
            return ret;
        }
        for (j = i + 1; j <= n; ++j) {
            if (s.queryArgument(j).equals(t.queryArgument(j))) continue;
            ret = new ArrayList();
            ret.add(new Pair<Position, Pair<Term, Term>>(Position.empty, new Pair<Term, Term>(s, t)));
            return ret;
        }
        for (j = 0; j < ret.size(); ++j) {
            ret.set(j, new Pair<ArgumentPos, Pair<Term, Term>>(new ArgumentPos(i, ret.get(j).fst()), ret.get(j).snd()));
        }
        ret.add(new Pair<Position, Pair<Term, Term>>(Position.empty, new Pair<Term, Term>(s, t)));
        return ret;
    }

    private static EndingStep createHdeleteAtPosition(Position pos, Term left, Term right, Term constraint, Optional<Term> leftbound, Optional<Term> rightbound, ProofState state) {
        int posArity = left.queryType().queryArity();
        final MutableSubstitution gamma = new MutableSubstitution();
        for (final Hypothesis hypo : state.getHypotheses()) {
            Term hypoLhs = hypo.getLhs();
            int hypoArity = hypoLhs.queryType().queryArity();
            if (hypoArity < posArity) continue;
            FinalPos extra = null;
            if (hypoArity > posArity) {
                extra = new FinalPos(hypoArity - posArity);
                left = left.querySubterm(extra);
                right = right.querySubterm(extra);
            }
            for (int i = 0; i < 2; ++i) {
                boolean inverse;
                boolean bl = inverse = i == 1;
                if (!DeductionHdelete.checkApplicability(leftbound, left, right, rightbound, constraint, hypo, inverse)) continue;
                final EquationPosition ep = new EquationPosition(EquationPosition.Side.Left, extra == null ? pos : pos.append(extra));
                return new EndingStep(){

                    @Override
                    public DeductionHdelete createStep(PartialProof proof, Optional<OutputModule> module) {
                        return DeductionHdelete.createStep(proof, module, hypo, inverse, ep, gamma);
                    }
                };
            }
        }
        return null;
    }

    static EndingStep seekFODisproveOrEqdelete(Term left, Term right, Term constraint) {
        Term c = TheoryFactory.createConjunction(constraint, TheoryFactory.notSymbol.apply(TheoryFactory.createEquality(left, right)));
        TermAnalyser.Result result = TermAnalyser.satisfy(c, Settings.smtSolver);
        Objects.requireNonNull(result);
        TermAnalyser.Result result2 = result;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TermAnalyser.Result.YES.class, TermAnalyser.Result.NO.class, TermAnalyser.Result.MAYBE.class}, (Object)result2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Substitution substitution;
                TermAnalyser.Result.YES yES = (TermAnalyser.Result.YES)result2;
                Substitution subst = substitution = yES.subst();
                return new DisproveTheoryStep(subst);
            }
            case 1: {
                TermAnalyser.Result.NO nO = (TermAnalyser.Result.NO)result2;
                return new EqdeleteStep();
            }
            case 2: 
        }
        TermAnalyser.Result.MAYBE mAYBE = (TermAnalyser.Result.MAYBE)result2;
        try {
            String string;
            String reason = string = mAYBE.reason();
            return null;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public static interface EndingStep {
        public DeductionStep createStep(PartialProof var1, Optional<OutputModule> var2);

        default public boolean requiresCompleteness() {
            return false;
        }
    }

    public record DeleteStep() implements EndingStep
    {
        @Override
        public DeductionDelete createStep(PartialProof proof, Optional<OutputModule> module) {
            return DeductionDelete.createStep(proof, module);
        }
    }

    public record DisproveTheoryStep(Substitution subst) implements EndingStep
    {
        @Override
        public DeductionDisproveTheory createStep(PartialProof proof, Optional<OutputModule> module) {
            return DeductionDisproveTheory.createStep(proof, module, this.subst);
        }

        @Override
        public boolean requiresCompleteness() {
            return true;
        }
    }

    public record EqdeleteStep() implements EndingStep
    {
        @Override
        public DeductionEqdelete createStep(PartialProof proof, Optional<OutputModule> module) {
            return DeductionEqdelete.createStep(proof, module);
        }
    }

    public record DisproveRootStep() implements EndingStep
    {
        @Override
        public DeductionDisproveRoot createStep(PartialProof proof, Optional<OutputModule> module) {
            return DeductionDisproveRoot.createStep(proof, module);
        }

        @Override
        public boolean requiresCompleteness() {
            return true;
        }
    }
}

