/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.automation;

import charlie.printer.Printer;
import charlie.substitution.MutableSubstitution;
import charlie.substitution.Substitution;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TheoryFactory;
import charlie.terms.Variable;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.theorytranslation.TermAnalyser;
import charlie.types.Type;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.deduction.DeductionDisproveRoot;
import cora.rwinduction.engine.deduction.DeductionDisproveTheory;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class AutoDisprover {
    public static DeductionStep createStep(PartialProof proof, Optional<OutputModule> module) {
        EquationContext ec = proof.getProofState().getTopEquation();
        Term left = ec.getLhs();
        Term right = ec.getRhs();
        if (left.queryType().isBaseType() && left.isTheoryTerm() && right.isTheoryTerm()) {
            Substitution subst = AutoDisprover.findContradictingTheorySubstitution(left, right, ec.getConstraint(), module, ec.getRenaming());
            if (subst == null) {
                return null;
            }
            return DeductionDisproveTheory.createStep(proof, module, subst);
        }
        return DeductionDisproveRoot.createStep(proof, module);
    }

    public static DeductionDisproveTheory createTheoryStep(PartialProof proof, Optional<OutputModule> module) {
        EquationContext ec = proof.getProofState().getTopEquation();
        Substitution subst = AutoDisprover.findContradictingTheorySubstitution(ec.getLhs(), ec.getRhs(), ec.getConstraint(), module, ec.getRenaming());
        if (subst == null) {
            return null;
        }
        return DeductionDisproveTheory.createStep(proof, module, subst);
    }

    public static Substitution findContradictingTheorySubstitution(Term l, Term r, Term c, Optional<OutputModule> module, Renaming renaming) {
        if (!l.queryType().isBaseType() || !r.queryType().isBaseType()) {
            module.ifPresent(o -> o.println("Theory disproves can only be done if both sides of the equation have base type.", new Object[0]));
            return null;
        }
        if (!l.isTheoryTerm() || !r.isTheoryTerm()) {
            module.ifPresent(o -> o.println("Theory disproves can only be done if both sides of the equation are theory terms.", new Object[0]));
            return null;
        }
        if (l.isFirstOrder() && r.isFirstOrder()) {
            return AutoDisprover.findBaseSubstitution(l, r, c, module, renaming);
        }
        return AutoDisprover.findHigherOrderSubstitution(l, r, c, module, renaming);
    }

    public static Substitution findBaseSubstitution(Term l, Term r, Term c, Optional<OutputModule> module, Renaming renaming) {
        Term combi = TheoryFactory.createConjunction(c, TheoryFactory.notSymbol.apply(TheoryFactory.createEquality(l, r)));
        TermAnalyser.Result result = TermAnalyser.satisfy(combi, Settings.smtSolver);
        Objects.requireNonNull(result);
        TermAnalyser.Result result2 = result;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TermAnalyser.Result.YES.class, TermAnalyser.Result.NO.class, TermAnalyser.Result.MAYBE.class}, (Object)result2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Substitution substitution;
                TermAnalyser.Result.YES yES = (TermAnalyser.Result.YES)result2;
                Substitution subst = substitution = yES.subst();
                return subst;
            }
            case 1: {
                TermAnalyser.Result.NO nO = (TermAnalyser.Result.NO)result2;
                module.ifPresent(o -> o.println("DISPROVE cannot be applied because %a is unsatisfiable; try EQ-DELETE instead!", Printer.makePrintable(combi, renaming)));
                return null;
            }
            case 2: 
        }
        TermAnalyser.Result.MAYBE mAYBE = (TermAnalyser.Result.MAYBE)result2;
        try {
            String string;
            String reason = string = mAYBE.reason();
            module.ifPresent(o -> o.println("Failed to apply DISPROVE, because the SMT solver cannot prove or disprove satisfiability of %a (the solver says \"%a\").", Printer.makePrintable(combi, renaming), reason));
            return null;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public static MutableSubstitution findHigherOrderSubstitution(Term l, Term r, Term c, Optional<OutputModule> module, Renaming renaming) {
        ArrayList<Variable> variables = AutoDisprover.getHOVars(l, r);
        ArrayList<ArrayList<Term>> instances = AutoDisprover.getHOInstances(variables, renaming, module);
        if (instances == null) {
            return null;
        }
        ArrayList<Integer> current = new ArrayList<Integer>();
        for (int i = 0; i < variables.size(); ++i) {
            current.add(0);
        }
        MutableSubstitution subst = new MutableSubstitution();
        int pos = 0;
        while (pos >= 0) {
            int k;
            if (pos == variables.size()) {
                if (AutoDisprover.findFirstOrderInstance(l, r, c, subst)) {
                    return subst;
                }
                --pos;
            }
            if ((k = ((Integer)current.get(pos)).intValue()) == instances.get(pos).size()) {
                subst.delete(variables.get(pos));
                current.set(pos, 0);
                --pos;
                continue;
            }
            subst.replace(variables.get(pos), instances.get(pos).get(k));
            current.set(pos, k + 1);
            ++pos;
        }
        module.ifPresent(o -> o.println("No substitution could be found that makes %a true and %a %{distinct} %a.  If such a substitution does exist, please supply it manually.", Printer.makePrintable(c, renaming), Printer.makePrintable(l, renaming), Printer.makePrintable(r, renaming)));
        return null;
    }

    private static ArrayList<Variable> getHOVars(Term left, Term right) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Variable x : left.vars()) {
            if (x.queryType().isBaseType()) continue;
            variables.add(x);
        }
        for (Variable x : right.vars()) {
            if (left.freeReplaceables().contains(x) || x.queryType().isBaseType()) continue;
            variables.add(x);
        }
        return variables;
    }

    private static ArrayList<ArrayList<Term>> getHOInstances(ArrayList<Variable> variables, Renaming renaming, Optional<OutputModule> module) {
        ArrayList<ArrayList<Term>> instances = new ArrayList<ArrayList<Term>>();
        for (int i = 0; i < variables.size(); ++i) {
            ArrayList<Term> inst = AutoDisprover.getAllInstances(variables.get(i).queryType());
            if (inst.size() == 0) {
                Variable x = variables.get(i);
                module.ifPresent(o -> o.println("There are no standard calculation symbols that could be used to instantiate the higher-order variable %a (of type %a).", renaming.getName(x), x.queryType()));
                return null;
            }
            instances.add(inst);
        }
        return instances;
    }

    static ArrayList<Term> getAllInstances(Type otype) {
        int oar = otype.queryArity();
        ArrayList<Term> ret = new ArrayList<Term>();
        for (FunctionSymbol functionSymbol : TheoryFactory.queryAllCalculationSymbols()) {
            Type t = functionSymbol.queryType();
            int k = t.queryArity();
            if (k < oar) continue;
            int n = k - oar;
            for (int i = 0; i < n; ++i) {
                t = t.subtype(2);
            }
            if (!t.equals(otype)) continue;
            Term term = functionSymbol;
            for (int i = 0; i < n; ++i) {
                term = term.apply(TermFactory.createVar(term.queryType().subtype(1)));
            }
            ret.add(term);
        }
        return ret;
    }

    private static boolean findFirstOrderInstance(Term left, Term right, Term constraint, MutableSubstitution gamma) {
        Substitution delta = AutoDisprover.findBaseSubstitution(gamma.substitute(left), gamma.substitute(right), gamma.substitute(constraint), Optional.empty(), null);
        if (delta == null) {
            return false;
        }
        gamma.combine(delta);
        ArrayList<Replaceable> remove = new ArrayList<Replaceable>();
        for (Replaceable x : gamma.domain()) {
            if (left.freeReplaceables().contains(x) || right.freeReplaceables().contains(x) || constraint.freeReplaceables().contains(x)) continue;
            remove.add(x);
        }
        for (Replaceable x : remove) {
            gamma.delete(x);
        }
        return true;
    }
}

