/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.automation;

import charlie.substitution.MutableSubstitution;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.position.FinalPos;
import charlie.terms.position.Position;
import charlie.trs.TRS;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.EquationPosition;
import cora.rwinduction.engine.Hypothesis;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.deduction.DeductionHypothesis;
import java.util.ArrayList;
import java.util.Optional;

public final class AutoHypothesis {
    public static DeductionHypothesis createHypothesisStep(PartialProof proof, OutputModule module) {
        Term b;
        Term a;
        EquationPosition.Side bside;
        EquationPosition.Side aside;
        int bscore;
        EquationContext ec = proof.getProofState().getTopEquation();
        TRS trs = proof.getContext().getTRS();
        int ascore = !ec.getLeftGreaterTerm().isPresent() ? 100 : AutoHypothesis.sideScore(trs, ec.getLeftGreaterTerm().get(), ec.getLhs());
        if (ascore >= (bscore = !ec.getRightGreaterTerm().isPresent() ? 100 : AutoHypothesis.sideScore(trs, ec.getRightGreaterTerm().get(), ec.getRhs()))) {
            aside = EquationPosition.Side.Left;
            bside = EquationPosition.Side.Right;
            a = ec.getLhs();
            b = ec.getRhs();
        } else {
            aside = EquationPosition.Side.Right;
            bside = EquationPosition.Side.Left;
            a = ec.getRhs();
            b = ec.getLhs();
        }
        ArrayList<DeductionHypothesis> options = new ArrayList<DeductionHypothesis>();
        int count = 0;
        for (Pair<Term, Position> pair : a.querySubterms()) {
            AutoHypothesis.tryStep(pair.fst(), aside, pair.snd(), proof, options);
            if (options.size() == count + 1) {
                return options.get(count);
            }
            count = options.size();
        }
        if (options.size() == 0 || ascore == bscore) {
            for (Pair<Term, Position> pair : b.querySubterms()) {
                AutoHypothesis.tryStep(pair.fst(), bside, pair.snd(), proof, options);
                if (options.size() == count + 1) {
                    return options.get(count);
                }
                count = options.size();
            }
        }
        if (options.size() == 0) {
            module.println("I cannot find a place where an induction hypothesis can clearly be applied.", new Object[0]);
        } else {
            module.println("There are multiple possible induction hypothesis steps, and it is not obvious which to choose from the following:", new Object[0]);
            module.startTable();
            for (DeductionHypothesis step : options) {
                module.nextColumn("*", new Object[0]);
                module.println(step.commandDescription(), new Object[0]);
            }
            module.endTable();
        }
        return null;
    }

    static EquationPosition.Side chooseBestSide(TRS trs, EquationContext ec) {
        if (!ec.getLeftGreaterTerm().isPresent()) {
            return EquationPosition.Side.Left;
        }
        if (!ec.getRightGreaterTerm().isPresent()) {
            return EquationPosition.Side.Right;
        }
        if (AutoHypothesis.sideScore(trs, ec.getLeftGreaterTerm().get(), ec.getLhs()) >= AutoHypothesis.sideScore(trs, ec.getRightGreaterTerm().get(), ec.getRhs())) {
            return EquationPosition.Side.Left;
        }
        return EquationPosition.Side.Right;
    }

    private static int sideScore(TRS trs, Term bounder, Term main) {
        return 2 * AutoHypothesis.leftOfOrderingRequirementScore(trs, bounder) + (bounder.equals(main) ? 0 : 1);
    }

    private static int leftOfOrderingRequirementScore(TRS trs, Term term) {
        if (!term.isFunctionalTerm()) {
            return 0;
        }
        if (term.queryRoot().toCalculationSymbol() != null) {
            return 1;
        }
        if (!trs.isDefined(term.queryRoot())) {
            return 2;
        }
        return 3;
    }

    private static DeductionHypothesis tryStep(Term s, EquationPosition.Side side, Position pos, PartialProof proof, ArrayList<DeductionHypothesis> ret) {
        int sar = s.queryType().queryArity();
        FunctionSymbol f = s.isFunctionalTerm() ? s.queryRoot() : null;
        for (Hypothesis hypo : proof.getProofState().getHypotheses()) {
            DeductionHypothesis step;
            int har = hypo.getLhs().queryType().queryArity();
            if (har < sar) continue;
            if (har != sar) {
                pos = pos.append(new FinalPos(har - sar));
            }
            if ((f == null || !hypo.getLhs().isFunctionalTerm() || f.equals(hypo.getLhs().queryRoot())) && (step = DeductionHypothesis.createStep(proof, Optional.empty(), hypo, false, new EquationPosition(side, pos), new MutableSubstitution())) != null && step.verify(Optional.empty())) {
                ret.add(step);
            }
            if (f != null && hypo.getRhs().isFunctionalTerm() && !f.equals(hypo.getRhs().queryRoot()) || (step = DeductionHypothesis.createStep(proof, Optional.empty(), hypo, true, new EquationPosition(side, pos), new MutableSubstitution())) == null || !step.verify(Optional.empty())) continue;
            ret.add(step);
        }
        return null;
    }
}

