/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.automation;

import charlie.substitution.MutableSubstitution;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.position.FinalPos;
import charlie.terms.position.Position;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.EquationPosition;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.deduction.DeductionCalc;
import cora.rwinduction.engine.deduction.DeductionSimplify;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public final class AutoSimplifier {
    public static DeductionSimplify createSingleStep(PartialProof proof, OutputModule module) {
        DeductionSimplify step;
        EquationContext ec = proof.getProofState().getTopEquation();
        for (Pair<Term, Position> pair : ec.getLhs().querySubterms()) {
            step = AutoSimplifier.createSingleStepAtPosition(proof, EquationPosition.Side.Left, pair.snd(), pair.fst());
            if (step == null) continue;
            return step;
        }
        for (Pair<Term, Position> pair : ec.getRhs().querySubterms()) {
            step = AutoSimplifier.createSingleStepAtPosition(proof, EquationPosition.Side.Right, pair.snd(), pair.fst());
            if (step == null) continue;
            return step;
        }
        module.println("I could not find any simplification step to apply.", new Object[0]);
        return null;
    }

    private static DeductionSimplify createSingleStepAtPosition(PartialProof proof, EquationPosition.Side side, Position pos, Term sub) {
        if (!sub.isFunctionalTerm()) {
            return null;
        }
        Function<Integer, EquationPosition> positionMaker = i -> i > 0 ? new EquationPosition(side, pos.append(new FinalPos((int)i))) : new EquationPosition(side, pos);
        return AutoSimplifier.findHeadSimplification(proof, sub.queryRoot(), sub.numberArguments(), positionMaker);
    }

    private static DeductionSimplify findHeadSimplification(PartialProof proof, FunctionSymbol f, int numberArguments, Function<Integer, EquationPosition> posMaker) {
        int k = proof.getContext().queryRuleArity(f);
        if (numberArguments < k) {
            return null;
        }
        EquationPosition ep = posMaker.apply(numberArguments - k);
        MutableSubstitution empty = new MutableSubstitution();
        Optional<OutputModule> m = Optional.empty();
        Set<String> names = proof.getContext().queryRuleNamesByFunction(f);
        if (names == null) {
            return null;
        }
        for (String rulename : names) {
            DeductionSimplify attempt = DeductionSimplify.createStep(proof, m, rulename, ep, empty);
            if (attempt == null || !attempt.verify(m)) continue;
            return attempt;
        }
        return null;
    }

    public static ArrayList<DeductionStep> simplifyFully(PartialProof proof) {
        EquationContext ec = proof.getProofState().getTopEquation();
        ArrayList<DeductionStep> ret = new ArrayList<DeductionStep>();
        AutoSimplifier.simplifyFully(proof, ec.getLhs(), EquationPosition.Side.Left, new LinkedList<Integer>(), ret);
        AutoSimplifier.simplifyFully(proof, ec.getRhs(), EquationPosition.Side.Right, new LinkedList<Integer>(), ret);
        return ret;
    }

    private static Term simplifyFully(PartialProof proof, Term s, EquationPosition.Side side, LinkedList<Integer> pos, ArrayList<DeductionStep> steps) {
        while (true) {
            int count = steps.size();
            ArrayList<Term> args = new ArrayList<Term>(s.numberArguments());
            for (int i2 = 1; i2 <= s.numberArguments(); ++i2) {
                pos.add(i2);
                args.add(AutoSimplifier.simplifyFully(proof, s.queryArgument(i2), side, pos, steps));
                pos.removeLast();
            }
            if (!s.isFunctionalTerm()) {
                if (steps.size() == count) {
                    return s;
                }
                return s.queryHead().apply(args);
            }
            DeductionStep step = s.queryRoot().toCalculationSymbol() != null && s.queryType().isBaseType() ? AutoSimplifier.findCalculation(proof, side, pos, args) : AutoSimplifier.findHeadSimplification(proof, s.queryRoot(), s.numberArguments(), i -> AutoSimplifier.makePos(side, pos, i));
            if (step == null || !step.execute(proof, Optional.empty())) {
                return s.queryHead().apply(args);
            }
            steps.add(step);
            s = proof.getProofState().getTopEquation().getEquation().querySubterm(AutoSimplifier.makePos(side, pos, 0));
        }
    }

    private static DeductionCalc findCalculation(PartialProof proof, EquationPosition.Side side, LinkedList<Integer> pos, ArrayList<Term> args) {
        for (Term term : args) {
            if (term.isValue() || term.isVariable()) continue;
            return null;
        }
        Optional<OutputModule> empty = Optional.empty();
        DeductionCalc ret = DeductionCalc.createStep(proof, empty, List.of(AutoSimplifier.makePos(side, pos, 0)));
        if (ret == null || !ret.verify(empty)) {
            return null;
        }
        return ret;
    }

    private static EquationPosition makePos(EquationPosition.Side side, LinkedList<Integer> main, int chop) {
        return new EquationPosition(side, Position.of(main, new FinalPos(chop)));
    }
}

