/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.automation;

import charlie.substitution.Substitution;
import charlie.terms.Term;
import charlie.terms.position.Position;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import cora.rwinduction.engine.automation.AutoDeleter;
import cora.rwinduction.engine.automation.AutoDisprover;
import cora.rwinduction.engine.automation.AutoSimplifier;
import cora.rwinduction.engine.deduction.DeductionContext;
import cora.rwinduction.engine.deduction.DeductionDelete;
import cora.rwinduction.engine.deduction.DeductionDisproveRoot;
import cora.rwinduction.engine.deduction.DeductionEqdelete;
import java.util.ArrayList;
import java.util.Optional;

public final class AutomaticProver {
    public static ArrayList<DeductionStep> handleBasics(PartialProof proof) {
        ArrayList<DeductionStep> ret = AutoSimplifier.simplifyFully(proof);
        EquationContext ec = proof.getProofState().getTopEquation();
        DeductionDelete dd = AutoDeleter.tryPureDelete(proof);
        if (dd != null) {
            ret.add(dd);
            return ret;
        }
        ArrayList<Position> posses = new ArrayList<Position>();
        ArrayList<Pair<Term, Term>> pairs = new ArrayList<Pair<Term, Term>>();
        DeductionContext.storeDifferences(ec.getLhs(), ec.getRhs(), proof.getContext(), posses, pairs);
        boolean incomplete = proof.getProofState().getIncompleteEquations().contains(ec.getIndex());
        ArrayList<AutoDeleter.EndingStep> steps = new ArrayList<AutoDeleter.EndingStep>();
        posses = AutomaticProver.categoriseAndReorder(pairs, posses, ec.getLeftGreaterTerm(), ec.getRightGreaterTerm(), ec.getConstraint(), proof.getProofState(), proof.getContext(), incomplete, steps);
        Optional<OutputModule> empty = Optional.empty();
        DeductionContext dc = DeductionContext.createStep(proof, Optional.empty(), posses);
        if (dc != null && dc.verifyAndExecute(proof, empty)) {
            ret.add(dc);
        }
        for (AutoDeleter.EndingStep step : steps) {
            DeductionStep s = step.createStep(proof, empty);
            if (s == null) {
                throw new RuntimeException("handleBasics created a step that cannot be created!");
            }
            if (!s.execute(proof, empty)) {
                throw new RuntimeException("handleBasics created a step " + s.commandDescription() + " that cannot be executed!");
            }
            ret.add(s);
        }
        return ret;
    }

    private static ArrayList<Position> categoriseAndReorder(ArrayList<Pair<Term, Term>> pairs, ArrayList<Position> posses, Optional<Term> leftbound, Optional<Term> rightbound, Term constraint, ProofState state, ProofContext context, boolean incomplete, ArrayList<AutoDeleter.EndingStep> steps) {
        ArrayList<Position> ret = new ArrayList<Position>();
        ArrayList<Position> tricky = new ArrayList<Position>();
        ArrayList<Position> rest = new ArrayList<Position>();
        for (int i = 0; i < posses.size(); ++i) {
            Term right;
            Position p = posses.get(i);
            Term left = pairs.get(i).fst();
            AutoDeleter.EndingStep step = AutomaticProver.categorise(left, right = pairs.get(i).snd(), constraint, leftbound, rightbound, state, context, incomplete);
            if (step == null) {
                if (left.isTheoryTerm() && right.isTheoryTerm()) {
                    tricky.add(p);
                    continue;
                }
                rest.add(p);
                continue;
            }
            if (step.requiresCompleteness() && incomplete) {
                tricky.add(p);
                continue;
            }
            ret.add(p);
            steps.add(step);
        }
        for (Position pos : tricky) {
            ret.add(pos);
        }
        for (Position pos : rest) {
            ret.add(pos);
        }
        return ret;
    }

    static AutoDeleter.EndingStep categorise(Term left, Term right, Term constraint, Optional<Term> leftbound, Optional<Term> rightbound, ProofState state, ProofContext context, boolean incomplete) {
        if (left.isTheoryTerm() && right.isTheoryTerm() && left.isFirstOrder() && right.isFirstOrder()) {
            return AutoDeleter.seekFODisproveOrEqdelete(left, right, constraint);
        }
        if (DeductionEqdelete.checkApplicability(left, right, constraint)) {
            return new AutoDeleter.EqdeleteStep();
        }
        AutoDeleter.EndingStep step = AutoDeleter.seekHdelete(left, right, constraint, leftbound, rightbound, state, Optional.empty());
        if (step != null) {
            return step;
        }
        if (DeductionDisproveRoot.checkDifferentSemiconstructors(left, right, context) != null) {
            return new AutoDeleter.EndingStep(){

                @Override
                public DeductionDisproveRoot createStep(PartialProof proof, Optional<OutputModule> module) {
                    return DeductionDisproveRoot.createStep(proof, module);
                }

                @Override
                public boolean requiresCompleteness() {
                    return true;
                }
            };
        }
        if (incomplete) {
            return null;
        }
        Substitution subst = AutoDisprover.findContradictingTheorySubstitution(left, right, constraint, Optional.empty(), null);
        if (subst != null) {
            return new AutoDeleter.DisproveTheoryStep(subst);
        }
        return null;
    }
}

