/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.terms.CalculationSymbol;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import charlie.terms.Variable;
import java.util.HashMap;
import java.util.Stack;

final class CalcHelper {
    CalcHelper() {
    }

    static boolean calculatable(Term term) {
        return term.isFunctionalTerm() && term.isApplication() && term.isTheoryTerm() && term.isFirstOrder();
    }

    static HashMap<Term, Variable> breakupConstraint(Term constraint) {
        HashMap<Term, Variable> ret = new HashMap<Term, Variable>();
        Stack<Term> todo = new Stack<Term>();
        todo.push(constraint);
        while (!todo.isEmpty()) {
            CalculationSymbol f;
            Term term = (Term)todo.pop();
            while (term.isFunctionalTerm() && term.queryRoot().equals(TheoryFactory.andSymbol) && term.numberArguments() == 2) {
                todo.push(term.queryArgument(2));
                term = term.queryArgument(1);
            }
            if (!term.isFunctionalTerm() || term.numberArguments() != 2 || (f = term.queryRoot().toCalculationSymbol()) == null || f.queryKind() != CalculationSymbol.Kind.EQUALS && f.queryKind() != CalculationSymbol.Kind.IFF) continue;
            if (term.queryArgument(1).isVariable() && !term.queryArgument(2).isVariable()) {
                ret.put(term.queryArgument(2), term.queryArgument(1).queryVariable());
            }
            if (!term.queryArgument(2).isVariable() || term.queryArgument(1).isVariable()) continue;
            ret.put(term.queryArgument(1), term.queryArgument(2).queryVariable());
        }
        return ret;
    }
}

