/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.PrintableObject;
import charlie.printer.Printer;
import charlie.smt.SmtSolver;
import charlie.substitution.Matcher;
import charlie.substitution.MutableSubstitution;
import charlie.substitution.Substitution;
import charlie.terms.CalculationSymbol;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import charlie.terms.Value;
import charlie.terms.Variable;
import charlie.terms.position.Position;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.theorytranslation.TermAnalyser;
import charlie.theorytranslation.TermSmtTranslator;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationPosition;
import cora.rwinduction.engine.ProofContext;
import java.util.ArrayList;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;

class ConstrainedSimplifier {
    private Term _left;
    private Term _right;
    private Term _constraint;
    private Renaming _renaming;
    private MutableSubstitution _substitution;
    private ArrayList<Pair<Variable, Term>> _definitions;

    ConstrainedSimplifier(Term left, Term right, Term constraint, Renaming renaming, Substitution subst) {
        this._left = left;
        this._right = right;
        this._renaming = renaming.makeImmutable();
        this._substitution = subst == null ? new MutableSubstitution() : subst.copy();
        this._definitions = new ArrayList();
        this._constraint = this.splitEqualities(constraint, this._definitions);
    }

    private Term splitEqualities(Term constraint, ArrayList<Pair<Variable, Term>> equalities) {
        if (!constraint.isFunctionalTerm()) {
            return constraint;
        }
        if (constraint.numberArguments() != 2) {
            return constraint;
        }
        CalculationSymbol calc = constraint.queryRoot().toCalculationSymbol();
        if (calc == null) {
            return constraint;
        }
        if (calc.queryKind() == CalculationSymbol.Kind.AND) {
            Term a = this.splitEqualities(constraint.queryArgument(1), equalities);
            Term b = this.splitEqualities(constraint.queryArgument(2), equalities);
            return TheoryFactory.createConjunction(a, b);
        }
        if (calc.queryKind() != CalculationSymbol.Kind.EQUALS && calc.queryKind() != CalculationSymbol.Kind.IFF) {
            return constraint;
        }
        Term a = constraint.queryArgument(1);
        Term b = constraint.queryArgument(2);
        if (a.isVariable()) {
            equalities.add(new Pair<Variable, Term>(a.queryVariable(), b));
            return TheoryFactory.trueValue;
        }
        if (b.isVariable()) {
            equalities.add(new Pair<Variable, Term>(b.queryVariable(), a));
            return TheoryFactory.trueValue;
        }
        return constraint;
    }

    Renaming queryRenaming() {
        return this._renaming;
    }

    Substitution querySubstitution() {
        return this._substitution.makeImmutable();
    }

    PrintableObject substitutionPrintable(Renaming equationRenaming) {
        return Printer.makePrintable(this._substitution, this._renaming, equationRenaming);
    }

    boolean constraintIsTrue() {
        return this._constraint.isValue() && this._constraint.toValue().getBool() && this._definitions.isEmpty();
    }

    TreeSet<Replaceable> queryMissingReplaceables() {
        TreeSet<Replaceable> missing = new TreeSet<Replaceable>();
        for (Replaceable replaceable : this._left.freeReplaceables()) {
            if (this._substitution.get(replaceable) != null) continue;
            missing.add(replaceable);
        }
        for (Replaceable replaceable : this._right.freeReplaceables()) {
            if (this._substitution.get(replaceable) != null) continue;
            missing.add(replaceable);
        }
        for (Replaceable replaceable : this._constraint.freeReplaceables()) {
            if (this._substitution.get(replaceable) != null) continue;
            missing.add(replaceable);
        }
        for (Pair pair : this._definitions) {
            if (this._substitution.get((Replaceable)pair.fst()) == null) {
                missing.add((Replaceable)pair.fst());
            }
            for (Replaceable x : ((Term)pair.snd()).freeReplaceables()) {
                if (this._substitution.get(x) != null) continue;
                missing.add(x);
            }
        }
        return missing;
    }

    boolean checkSemiConstructorSubstitution(ProofContext context) {
        for (Replaceable x : this._substitution.domain()) {
            Term result = this._substitution.get(x);
            for (Pair<Term, Position> pair : result.querySubterms()) {
                FunctionSymbol f;
                Term t = pair.fst();
                if (!t.isFunctionalTerm() || (f = t.queryRoot()).toCalculationSymbol() == null && !context.getTRS().isDefined(f) || context.queryRuleArity(f) > t.numberArguments()) continue;
                return false;
            }
        }
        return true;
    }

    void replaceSubstitution(Substitution subst) {
        this._substitution = subst == null ? new MutableSubstitution() : subst.copy();
    }

    Matcher.MatchFailure matchLeft(Term s) {
        return Matcher.extendMatch(this._left, s, this._substitution);
    }

    Matcher.MatchFailure matchRight(Term t) {
        return Matcher.extendMatch(this._right, t, this._substitution);
    }

    boolean matchEqualitiesInConstraint(Term psi) {
        ArrayList<Pair<Variable, Term>> eqs = new ArrayList<Pair<Variable, Term>>();
        this.splitEqualities(psi, eqs);
        boolean anythingAdded = false;
        for (Pair<Variable, Term> myPair : this._definitions) {
            Term t;
            Variable x = myPair.fst();
            if (this._substitution.get(x) != null || !this.allSubstituted(t = myPair.snd())) continue;
            Term tgamma = this._substitution.substitute(t);
            Term result = null;
            for (Pair<Variable, Term> pair : eqs) {
                if (!tgamma.equals(pair.snd())) continue;
                result = pair.fst();
                break;
            }
            if (result == null) {
                result = this.calculateGroundTerm(tgamma);
            }
            if (result == null) continue;
            anythingAdded = true;
            this._substitution.extend(x, result);
        }
        return anythingAdded;
    }

    Term queryReduct() {
        return this._substitution.substitute(this._right);
    }

    ArrayList<Pair<Pair<Variable, String>, Term>> addDefinitionsToSubstitution(Function<Variable, Pair<Variable, String>> derivativeChooser) {
        ArrayList<Pair<Pair<Variable, String>, Term>> ret = new ArrayList<Pair<Pair<Variable, String>, Term>>();
        for (Pair<Variable, Term> pair : this._definitions) {
            Term t;
            Variable x = pair.fst();
            if (this._substitution.get(x) != null || !this.allSubstituted(t = pair.snd())) continue;
            Term tgamma = this._substitution.substitute(t);
            Pair<Variable, String> ypair = derivativeChooser.apply(x);
            ret.add(new Pair<Pair<Variable, String>, Term>(ypair, tgamma));
            this._substitution.extend(x, ypair.fst());
        }
        return ret;
    }

    private boolean allSubstituted(Term t) {
        for (Variable y : t.vars()) {
            if (this._substitution.get(y) != null) continue;
            return false;
        }
        return true;
    }

    private Value calculateGroundTerm(Term t) {
        if (t.isGround() && t.isTheoryTerm() && t.queryType().isBaseType()) {
            return TermAnalyser.evaluate(t);
        }
        return null;
    }

    boolean matchSubterm(Equation eq, EquationPosition pos, Optional<OutputModule> m, String kind) {
        Term s = eq.querySubterm(pos);
        if (s == null) {
            m.ifPresent(o -> o.println("No such position: %a.", pos));
            return false;
        }
        Matcher.MatchFailure problem = Matcher.extendMatch(this._left, s, this._substitution);
        if (problem != null) {
            m.ifPresent(o -> o.println("The " + kind + " does not apply due to failed matching (matching debug info says: %a)", Printer.makePrintable(problem, this._renaming)));
            return false;
        }
        return true;
    }

    boolean canReduceCtermWithConstraint(Term psi, SmtSolver solver, Renaming psiNaming, Optional<OutputModule> module, String kind) {
        if (!this.checkConstraintVariables(psi, psiNaming, module, kind)) {
            return false;
        }
        return this.checkImplication(psi, psiNaming, solver, module, kind);
    }

    private boolean checkConstraintVariables(Term equationConstraint, Renaming equationNaming, Optional<OutputModule> module, String kind) {
        TreeSet<Variable> vars = new TreeSet<Variable>();
        for (Variable variable : this._constraint.vars()) {
            vars.add(variable);
        }
        for (Pair pair : this._definitions) {
            vars.add((Variable)pair.fst());
            for (Variable x : ((Term)pair.snd()).vars()) {
                vars.add(x);
            }
        }
        for (Variable variable : vars) {
            Term t = this._substitution.get(variable);
            if (t == null) {
                module.ifPresent(o -> o.println("The " + kind + " does not apply: constraint variable %a is not mapped to anything.", this._renaming.getName(x)));
                return false;
            }
            if (t.isValue() || t.isVariable()) continue;
            module.ifPresent(o -> o.println("The " + kind + " does not apply: constraint variable %a is instantiated by %a, which is not a value or variable.", this._renaming.getName(x), Printer.makePrintable(t, equationNaming)));
            return false;
        }
        return true;
    }

    private boolean checkImplication(Term psi, Renaming psirenaming, SmtSolver solver, Optional<OutputModule> module, String kind) {
        Term c = this._constraint;
        for (Pair<Variable, Term> d : this._definitions) {
            c = TheoryFactory.createConjunction(c, TheoryFactory.createEquality(d.fst(), d.snd()));
        }
        Term substitutedconstr = this._substitution.substitute(c);
        TermSmtTranslator translator = new TermSmtTranslator();
        translator.requireImplication(psi, substitutedconstr);
        if (solver.checkValidity(translator.queryProblem())) {
            return true;
        }
        if (module.isPresent()) {
            ArrayList<Term> badConstraints = new ArrayList<Term>();
            this.storeUnsatisfiedConstraints(psi, substitutedconstr, badConstraints, solver);
            OutputModule m = module.get();
            m.print("The " + kind + " does not apply: I could not prove that ", new Object[0]);
            for (int i = 0; i < badConstraints.size(); ++i) {
                if (i != 0) {
                    m.print(" nor ", new Object[0]);
                }
                m.print("%a %{Vdash} %a", Printer.makePrintable(psi, psirenaming), Printer.makePrintable(badConstraints.get(i), psirenaming));
            }
            m.println(".", new Object[0]);
        }
        return false;
    }

    private void storeUnsatisfiedConstraints(Term premise, Term conclusion, ArrayList<Term> storage, SmtSolver solver) {
        CalculationSymbol calc;
        if (conclusion.isFunctionalTerm() && (calc = conclusion.queryRoot().toCalculationSymbol()) != null && calc.queryKind() == CalculationSymbol.Kind.AND) {
            for (int i = 1; i <= conclusion.numberArguments(); ++i) {
                this.storeUnsatisfiedConstraints(premise, conclusion.queryArgument(i), storage, solver);
            }
            return;
        }
        TermSmtTranslator translator = new TermSmtTranslator();
        translator.requireImplication(premise, conclusion);
        if (!solver.checkValidity(translator.queryProblem())) {
            storage.add(conclusion);
        }
    }

    boolean checkEverythingSubstituted(Optional<OutputModule> module) {
        TreeSet<Replaceable> missing = this.queryMissingReplaceables();
        if (missing.isEmpty()) {
            return true;
        }
        if (!module.isPresent()) {
            return false;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Replaceable x : missing) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(this._renaming.getName(x));
        }
        module.ifPresent(m -> m.println("Not enough information given: I could not determine the substitution to be used for %a.", builder.toString()));
        return false;
    }
}

