/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.Term;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.theorytranslation.TermSmtTranslator;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.Optional;

public final class DeductionAlterConstraint
extends DeductionStep {
    private Term _originalConstraint;
    private Term _newConstraint;

    private DeductionAlterConstraint(ProofState state, ProofContext context, Term original, Term update) {
        super(state, context);
        this._originalConstraint = original;
        this._newConstraint = update;
    }

    public static DeductionAlterConstraint createStep(PartialProof proof, Optional<OutputModule> module, Term newConstraint) {
        ProofState state = proof.getProofState();
        EquationContext original = state.getTopEquation();
        Renaming renaming = original.getRenaming();
        for (Replaceable x : newConstraint.freeReplaceables()) {
            if (renaming.getName(x) != null) continue;
            module.ifPresent(o -> o.println("Fresh occurrence of " + x.queryName() + " is not allowed in this application of the ALTER command (use alter ADD to add new variables to the constraint).", new Object[0]));
            return null;
        }
        return new DeductionAlterConstraint(state, proof.getContext(), original.getEquation().getConstraint(), newConstraint);
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        TermSmtTranslator translator = new TermSmtTranslator();
        translator.requireImplication(this._originalConstraint, this._newConstraint);
        translator.requireImplication(this._newConstraint, this._originalConstraint);
        if (Settings.smtSolver.checkValidity(translator.queryProblem())) {
            return true;
        }
        module.ifPresent(o -> o.println("It is not obvious if this usage of alteration is permitted: I could not prove that %a %{iff} %a.", Printer.makePrintable(this._originalConstraint, this._state.getTopEquation().getRenaming()), Printer.makePrintable(this._newConstraint, this._state.getTopEquation().getRenaming())));
        return false;
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        Equation oldEquation = this._state.getTopEquation().getEquation();
        Equation newEquation = new Equation(oldEquation.getLhs(), oldEquation.getRhs(), this._newConstraint);
        return this._state.replaceTopEquation(this._state.getTopEquation().replace(newEquation, this._state.getLastUsedIndex() + 1));
    }

    @Override
    public String commandDescription() {
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        printer.add("alter constraint ");
        Object[] objectArray = new Object[1];
        objectArray[0] = Printer.makePrintable(this._newConstraint, this._state.getTopEquation().getRenaming());
        printer.add(objectArray);
        return printer.toString();
    }

    @Override
    public void explain(OutputModule module) {
        module.println("We apply ALTER to replace the constraint of %a by %a.", this._equ.getName(), Printer.makePrintable(this._newConstraint, this._state.getTopEquation().getRenaming()));
    }
}

