/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import charlie.terms.Variable;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.ArrayList;
import java.util.Optional;

public final class DeductionAlterDefinitions
extends DeductionStep {
    private ArrayList<Term> _definitions;
    private Renaming _updatedRenaming;

    private DeductionAlterDefinitions(ProofState state, ProofContext context, ArrayList<Term> defs, Renaming naming) {
        super(state, context);
        this._definitions = defs;
        this._updatedRenaming = naming.makeImmutable();
    }

    Renaming queryUpdatedRenaming() {
        return this._updatedRenaming;
    }

    public static DeductionAlterDefinitions createStep(PartialProof proof, Optional<OutputModule> module, ArrayList<Pair<Pair<Variable, String>, Term>> defs) {
        ProofState state = proof.getProofState();
        EquationContext ec = DeductionAlterDefinitions.getTopEquation(state, module);
        if (ec == null) {
            return null;
        }
        MutableRenaming renaming = ec.getRenaming().copy();
        ArrayList<Term> d = new ArrayList<Term>();
        if (defs.size() == 0) {
            module.ifPresent(o -> o.println("Cannot introduce an empty number of definitions.", new Object[0]));
            return null;
        }
        for (Pair<Pair<Variable, String>, Term> tuple : defs) {
            Term value;
            String name;
            Variable x = tuple.fst().fst();
            if (!DeductionAlterDefinitions.checkMapping(x, name = tuple.fst().snd(), value = tuple.snd(), renaming, module)) {
                return null;
            }
            if (!renaming.setName(x, name)) {
                module.ifPresent(o -> o.println("Invalid variable name: " + name, new Object[0]));
                return null;
            }
            d.add(TheoryFactory.createEquality(x, value));
        }
        return new DeductionAlterDefinitions(state, proof.getContext(), d, renaming);
    }

    private static boolean checkMapping(Variable x, String xname, Term value, Renaming renaming, Optional<OutputModule> module) {
        if (renaming.getName(x) != null) {
            module.ifPresent(o -> o.println("Definition for variable [%a] not allowed: this variable already occurs in the equation context.", xname));
            return false;
        }
        if (renaming.getReplaceable(xname) != null) {
            module.ifPresent(o -> o.println("Definition for variable [%a] not allowed: this name has already been used in the equation context.", xname));
            return false;
        }
        if (!x.queryType().isBaseType() || !x.queryType().isTheoryType()) {
            module.ifPresent(o -> o.println("Variable %a has type %a, which is not a theory sort.", xname, x.queryType()));
            return false;
        }
        for (Variable y : value.vars()) {
            if (renaming.getName(y) != null) continue;
            module.ifPresent(o -> o.println("Unknown variable %a in definition of %a.", y.queryName(), xname));
            return false;
        }
        if (!value.isFirstOrder() || !value.isTheoryTerm()) {
            module.ifPresent(o -> o.println("Value %a is not a (first-order) theory term, so does not belong in the constraint!", Printer.makePrintable(value, renaming)));
            return false;
        }
        if (!x.queryType().equals(value.queryType())) {
            module.ifPresent(o -> o.println("Type error: variable %a has type %a while %a has type %a.", xname, x.queryType(), Printer.makePrintable(value, renaming), value.queryType()));
            return false;
        }
        return true;
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        return true;
    }

    public Term queryAddedConstraint() {
        Term constraint = TheoryFactory.trueValue;
        for (Term def : this._definitions) {
            constraint = TheoryFactory.createConjunction(constraint, def);
        }
        return constraint;
    }

    public Term queryUpdatedConstraint() {
        Term constraint = this._state.getTopEquation().getEquation().getConstraint();
        for (Term def : this._definitions) {
            constraint = TheoryFactory.createConjunction(constraint, def);
        }
        return constraint;
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        Equation old = this._state.getTopEquation().getEquation();
        Term constraint = old.getConstraint();
        for (Term def : this._definitions) {
            constraint = TheoryFactory.createConjunction(constraint, def);
        }
        Equation equation = new Equation(old.getLhs(), old.getRhs(), constraint);
        return this._state.replaceTopEquation(this._state.getTopEquation().replace(equation, this._updatedRenaming, this._state.getLastUsedIndex() + 1));
    }

    @Override
    public String commandDescription() {
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        printer.add("alter add ");
        for (int i = 0; i < this._definitions.size(); ++i) {
            if (i != 0) {
                printer.add(", ");
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = Printer.makePrintable(this._definitions.get(i).queryArgument(1), this._updatedRenaming);
            objectArray[1] = " = ";
            objectArray[2] = Printer.makePrintable(this._definitions.get(i).queryArgument(2), this._updatedRenaming);
            printer.add(objectArray);
        }
        return printer.toString();
    }

    @Override
    public void explain(OutputModule module) {
        Term newConstraint = TheoryFactory.trueValue;
        for (Term c : this._definitions) {
            newConstraint = TheoryFactory.createConjunction(newConstraint, c);
        }
        module.println("We apply ALTER to add %a to the constraint of %a.", Printer.makePrintable(newConstraint, this._updatedRenaming), this._equ.getName());
    }
}

