/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.Term;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.theorytranslation.TermSmtTranslator;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.Optional;

public final class DeductionAlterGeneraliseConstraint
extends DeductionStep {
    private Term _originalConstraint;
    private Term _newConstraint;
    private boolean _alters;

    private DeductionAlterGeneraliseConstraint(ProofState state, ProofContext context, Term original, Term update, boolean isAlter) {
        super(state, context);
        this._originalConstraint = original;
        this._newConstraint = update;
        this._alters = isAlter;
    }

    private static boolean checkNoFreshVariables(EquationContext original, Term newConstraint, String cmd, Optional<OutputModule> module) {
        Renaming renaming = original.getRenaming();
        for (Replaceable x : newConstraint.freeReplaceables()) {
            if (renaming.getName(x) != null) continue;
            module.ifPresent(o -> o.println("Fresh occurrence of " + x.queryName() + " is not allowed in this application of the " + cmd + " command (use ALTER ADD to add new variables to the constraint).", new Object[0]));
            return false;
        }
        return true;
    }

    public static DeductionAlterGeneraliseConstraint createAlterStep(PartialProof proof, Optional<OutputModule> module, Term newConstraint) {
        ProofState state = proof.getProofState();
        EquationContext original = state.getTopEquation();
        if (!DeductionAlterGeneraliseConstraint.checkNoFreshVariables(original, newConstraint, "ALTER", module)) {
            return null;
        }
        return new DeductionAlterGeneraliseConstraint(state, proof.getContext(), original.getEquation().getConstraint(), newConstraint, true);
    }

    public static DeductionAlterGeneraliseConstraint createGeneraliseStep(PartialProof proof, Optional<OutputModule> mod, Term newConstraint) {
        ProofState state = proof.getProofState();
        EquationContext original = state.getTopEquation();
        if (!DeductionAlterGeneraliseConstraint.checkNoFreshVariables(original, newConstraint, "GENERALISE", mod)) {
            return null;
        }
        return new DeductionAlterGeneraliseConstraint(state, proof.getContext(), original.getEquation().getConstraint(), newConstraint, false);
    }

    private String queryCommandName(boolean capitalise) {
        if (this._alters) {
            if (capitalise) {
                return "ALTER";
            }
            return "alter";
        }
        if (capitalise) {
            return "GENERALISE";
        }
        return "generalise";
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        TermSmtTranslator translator = new TermSmtTranslator();
        translator.requireImplication(this._originalConstraint, this._newConstraint);
        if (this._alters) {
            translator.requireImplication(this._newConstraint, this._originalConstraint);
        }
        if (Settings.smtSolver.checkValidity(translator.queryProblem())) {
            return true;
        }
        module.ifPresent(o -> o.println("It is not obvious if this usage of " + this.queryCommandName(false) + " is permitted: I could not prove that %a " + (this._alters ? "%{iff}" : "%{implies}") + " %a.", Printer.makePrintable(this._originalConstraint, this._state.getTopEquation().getRenaming()), Printer.makePrintable(this._newConstraint, this._state.getTopEquation().getRenaming())));
        return false;
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        Equation oldEquation = this._state.getTopEquation().getEquation();
        Equation newEquation = new Equation(oldEquation.getLhs(), oldEquation.getRhs(), this._newConstraint);
        int newIndex = this._state.getLastUsedIndex() + 1;
        ProofState ret = this._state.replaceTopEquation(this._state.getTopEquation().replace(newEquation, newIndex));
        if (!this._alters) {
            ret = ret.setIncomplete(newIndex);
        }
        return ret;
    }

    @Override
    public String commandDescription() {
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        printer.add(this.queryCommandName(false) + " constraint ");
        Object[] objectArray = new Object[1];
        objectArray[0] = Printer.makePrintable(this._newConstraint, this._state.getTopEquation().getRenaming());
        printer.add(objectArray);
        return printer.toString();
    }

    @Override
    public void explain(OutputModule module) {
        module.println("We apply %a to replace the constraint of %a by %a.", this.queryCommandName(true), this._equ.getName(), Printer.makePrintable(this._newConstraint, this._state.getTopEquation().getRenaming()));
    }
}

