/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.ArrayList;
import java.util.Optional;

public final class DeductionAlterRename
extends DeductionStep {
    private ArrayList<Pair<String, String>> _assignments;
    private Renaming _newRenaming;

    private DeductionAlterRename(ProofState state, ProofContext context, ArrayList<Pair<String, String>> assignments, Renaming renaming) {
        super(state, context);
        this._assignments = assignments;
        this._newRenaming = renaming.makeImmutable();
    }

    public static DeductionAlterRename createStep(PartialProof proof, Optional<OutputModule> module, ArrayList<Pair<String, String>> mapping) {
        ProofState state = proof.getProofState();
        MutableRenaming renaming = state.getTopEquation().getRenaming().copy();
        for (Pair<String, String> pair : mapping) {
            String original = pair.fst();
            String newname = pair.snd();
            Replaceable x = renaming.getReplaceable(original);
            if (x == null) {
                module.ifPresent(o -> o.println("Unknown variable name: %a.", original));
                return null;
            }
            if (original.equals(newname)) {
                module.ifPresent(o -> o.println("Cannot rename variable %a to itself.", original));
                return null;
            }
            if (renaming.getReplaceable(newname) != null) {
                module.ifPresent(o -> o.println("The name %a is already in use.", newname));
                return null;
            }
            if (renaming.setName(x, newname)) continue;
            module.ifPresent(o -> o.println("The name %a is not available.", newname));
            return null;
        }
        if (mapping.isEmpty()) {
            module.ifPresent(o -> o.println("Nothing given to rename.", new Object[0]));
            return null;
        }
        return new DeductionAlterRename(state, proof.getContext(), mapping, renaming);
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        return true;
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        return this._state.replaceTopEquation(this._state.getTopEquation().replace(this._state.getTopEquation().getEquation(), this._newRenaming, this._state.getLastUsedIndex() + 1));
    }

    @Override
    public String commandDescription() {
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        printer.add("alter rename ");
        for (int i = 0; i < this._assignments.size(); ++i) {
            if (i != 0) {
                printer.add(", ");
            }
            printer.add(this._assignments.get(i).fst(), " := ", this._assignments.get(i).snd());
        }
        return printer.toString();
    }

    @Override
    public void explain(OutputModule module) {
        module.print("We apply ALTER to rename variables using the substitution [", new Object[0]);
        for (int i = 0; i < this._assignments.size(); ++i) {
            if (i != 0) {
                module.print(", ", new Object[0]);
            }
            module.print("%a := %a", this._assignments.get(i).fst(), this._assignments.get(i).snd());
        }
        module.println("].", new Object[0]);
    }
}

