/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.FunctionSymbol;
import charlie.terms.InvalidPositionException;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import charlie.terms.Variable;
import charlie.terms.position.Position;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.theorytranslation.TermAnalyser;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.EquationPosition;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import cora.rwinduction.engine.deduction.CalcHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public final class DeductionCalc
extends DeductionStep {
    private List<EquationPosition> _position;
    private List<Term> _replacement;
    private Term _newconstraint;
    private HashMap<String, Variable> _newvars;

    private DeductionCalc(ProofState state, ProofContext context, List<EquationPosition> pos, List<Term> replacement, Term constr, HashMap<String, Variable> newvars) {
        super(state, context);
        this._position = pos;
        this._replacement = replacement;
        this._newconstraint = constr;
        this._newvars = newvars;
    }

    private MutableRenaming makeNewRenaming() {
        MutableRenaming renaming = this._equ.getRenaming().copy();
        for (String name : this._newvars.keySet()) {
            renaming.setName(this._newvars.get(name), name);
        }
        return renaming;
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        Term left = this._equ.getEquation().getLhs();
        Term right = this._equ.getEquation().getRhs();
        Term constraint = this._equ.getEquation().getConstraint();
        block4: for (int i = 0; i < this._position.size(); ++i) {
            EquationPosition pos = this._position.get(i);
            Term replacement = this._replacement.get(i);
            switch (pos.querySide()) {
                case Left: {
                    left = left.replaceSubterm(pos.queryPosition(), replacement);
                    continue block4;
                }
                case Right: {
                    right = right.replaceSubterm(pos.queryPosition(), replacement);
                }
            }
        }
        if (this._newconstraint != null) {
            constraint = TheoryFactory.createConjunction(constraint, this._newconstraint);
        }
        Equation newequation = new Equation(left, right, constraint);
        EquationContext context = this._newconstraint == null ? this._equ.replace(newequation, this._state.getLastUsedIndex() + 1) : this._equ.replace(newequation, this.makeNewRenaming(), this._state.getLastUsedIndex() + 1);
        return this._state.replaceTopEquation(context);
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        return true;
    }

    @Override
    public String commandDescription() {
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        printer.add("calc ");
        for (EquationPosition pos : this._position) {
            printer.add(pos, " ");
        }
        return printer.toString().trim();
    }

    @Override
    public void explain(OutputModule module) {
        if (this._newconstraint != null) {
            MutableRenaming renaming = this.makeNewRenaming();
            module.print("We use ALTER to add %a to the constraint, and then ", Printer.makePrintable(this._newconstraint, (Renaming)renaming));
        } else {
            module.print("We ", new Object[0]);
        }
        if (this._position.size() == 1) {
            module.print("use CALC at position ", new Object[0]);
        } else {
            module.print("use CALC at positions ", new Object[0]);
        }
        for (int i = 0; i < this._position.size(); ++i) {
            if (i != 0 && i == this._position.size() - 1) {
                module.print(" and ", new Object[0]);
            } else if (i >= 1) {
                module.print(", ", new Object[0]);
            }
            module.print("%a", this._position.get(i));
        }
        module.println(".", new Object[0]);
    }

    public static DeductionCalc createStep(PartialProof proof, Optional<OutputModule> m, List<EquationPosition> posses) {
        EquationContext ec = DeductionCalc.getTopEquation(proof.getProofState(), m);
        if (ec == null) {
            return null;
        }
        MutableRenaming renaming = ec.getRenaming().copy();
        HashMap<Term, Variable> definedVars = CalcHelper.breakupConstraint(ec.getConstraint());
        ChangeablePair pair = new ChangeablePair(ec.getLhs(), ec.getRhs());
        Term constraint = TheoryFactory.trueValue;
        HashMap<String, Variable> newvars = new HashMap<String, Variable>();
        ArrayList<Term> replacements = new ArrayList<Term>();
        for (EquationPosition pos : posses) {
            Term newconstr = DeductionCalc.tryComputing(pos, pair, definedVars, newvars, replacements, renaming, ec.getEquation(), m, proof);
            if (newconstr == null) {
                return null;
            }
            constraint = TheoryFactory.createConjunction(constraint, newconstr);
        }
        if (constraint.isValue()) {
            constraint = null;
        }
        return new DeductionCalc(proof.getProofState(), proof.getContext(), posses, replacements, constraint, newvars);
    }

    private static Term tryComputing(EquationPosition pos, ChangeablePair pair, HashMap<Term, Variable> definedVars, HashMap<String, Variable> newvars, List<Term> replacements, MutableRenaming renaming, Equation original, Optional<OutputModule> m, PartialProof proof) {
        Term sub;
        try {
            sub = pair.subterm(pos);
        }
        catch (InvalidPositionException e) {
            String msg = original.querySubterm(pos) == null ? "No such position: %a." : "Subterm at position %a has already been calculated away!";
            m.ifPresent(o -> o.println(msg, pos));
            return null;
        }
        if (!CalcHelper.calculatable(sub)) {
            m.ifPresent(o -> o.println("The subterm %a at position %a is not calculatable: it should be a first-order theory term.", sub, pos));
            return null;
        }
        Term ret = TheoryFactory.trueValue;
        Term replacement = sub.isGround() ? TermAnalyser.evaluate(sub) : (Term)definedVars.get(sub);
        if (replacement == null) {
            Variable newvar = proof.getContext().getVariableNamer().chooseDerivativeForTerm(sub, renaming, sub.queryType().toString().substring(0, 1).toLowerCase(), DeductionCalc.getParent(pair, pos));
            newvars.put(renaming.getName(newvar), newvar);
            definedVars.put(sub, newvar);
            ret = TheoryFactory.createEquality(newvar, sub);
            replacement = newvar;
        }
        pair.replace(pos, replacement);
        replacements.add(replacement);
        return ret;
    }

    private static Pair<FunctionSymbol, Integer> getParent(ChangeablePair pair, EquationPosition pos) {
        Term t = switch (pos.querySide()) {
            default -> throw new MatchException(null, null);
            case EquationPosition.Side.Left -> pair.left;
            case EquationPosition.Side.Right -> pair.right;
        };
        Position p = pos.queryPosition();
        if (p.isFinal()) {
            return null;
        }
        while (!p.queryTail().isFinal()) {
            t = t.queryArgument(p.queryHead());
            p = p.queryTail();
        }
        if (!t.isFunctionalTerm()) {
            return null;
        }
        return new Pair<FunctionSymbol, Integer>(t.queryRoot(), p.queryHead());
    }

    private static class ChangeablePair {
        Term left;
        Term right;

        ChangeablePair(Term l, Term r) {
            this.left = l;
            this.right = r;
        }

        Term subterm(EquationPosition pos) {
            return switch (pos.querySide()) {
                default -> throw new MatchException(null, null);
                case EquationPosition.Side.Left -> this.left.querySubterm(pos.queryPosition());
                case EquationPosition.Side.Right -> this.right.querySubterm(pos.queryPosition());
            };
        }

        void replace(EquationPosition pos, Term replacement) {
            if (pos.querySide() == EquationPosition.Side.Left) {
                this.left = this.left.replaceSubterm(pos.queryPosition(), replacement);
            } else {
                this.right = this.right.replaceSubterm(pos.queryPosition(), replacement);
            }
        }
    }
}

