/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.substitution.MutableSubstitution;
import charlie.substitution.Substitution;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TheoryFactory;
import charlie.terms.Value;
import charlie.terms.Variable;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.types.Type;
import charlie.types.TypeFactory;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;

public final class DeductionCase
extends DeductionStep {
    private Term _term;
    private ArrayList<ExtraInfo> _cases;

    private DeductionCase(ProofState state, ProofContext context, Term term, ArrayList<ExtraInfo> cases) {
        super(state, context);
        this._term = term;
        this._cases = cases;
    }

    public static DeductionCase createStep(PartialProof proof, Optional<OutputModule> module, Term caseterm) {
        ProofState state = proof.getProofState();
        EquationContext ec = DeductionStep.getTopEquation(state, module);
        if (ec == null) {
            return null;
        }
        Renaming renaming = ec.getRenaming();
        ArrayList<ExtraInfo> ret = new ArrayList<ExtraInfo>();
        if (caseterm.queryType().equals(TypeFactory.boolSort)) {
            if (!DeductionCase.createBooleanCases(caseterm, renaming, module, ret)) {
                return null;
            }
        } else if (caseterm.queryType().equals(TypeFactory.intSort)) {
            if (!DeductionCase.createIntegerCases(caseterm, renaming, module, ret)) {
                return null;
            }
        } else {
            if (!DeductionCase.nonTheoryCasesApplicable(caseterm, renaming, module)) {
                return null;
            }
            DeductionCase.createConstructorCases(caseterm.queryVariable(), renaming, proof.getContext(), ret);
            if (caseterm.queryType().isProductType()) {
                DeductionCase.createTupleCase(caseterm.queryVariable(), renaming, proof.getContext(), ret);
            }
        }
        return new DeductionCase(state, proof.getContext(), caseterm, ret);
    }

    private static boolean createBooleanCases(Term caseterm, Renaming renaming, Optional<OutputModule> module, ArrayList<ExtraInfo> ret) {
        if (!caseterm.isTheoryTerm() || !caseterm.isFirstOrder()) {
            module.ifPresent(m -> m.println("Cannot do case analysis on %a: this is a boolean term, but not a first-order theory term, so it cannot be added to the constraint.", Printer.makePrintable(caseterm, renaming)));
            return false;
        }
        Term notcaseterm = TheoryFactory.notSymbol.apply(caseterm);
        MutableSubstitution empty = new MutableSubstitution();
        ret.add(new ExtraInfo(empty, caseterm, renaming));
        ret.add(new ExtraInfo(empty, notcaseterm, renaming));
        return true;
    }

    private static boolean createIntegerCases(Term caseterm, Renaming renaming, Optional<OutputModule> module, ArrayList<ExtraInfo> ret) {
        if (!caseterm.isTheoryTerm() || !caseterm.isFirstOrder()) {
            module.ifPresent(o -> o.println("Cannot do case analysis on %a: this is an integer term, but not a first-order theory term, so it cannot be included in the constraint.", Printer.makePrintable(caseterm, renaming)));
            return false;
        }
        Value zero = TheoryFactory.zeroValue;
        Term greater = TermFactory.createApp(TheoryFactory.greaterSymbol, caseterm, zero);
        Term equal = TermFactory.createApp(TheoryFactory.intEqualSymbol, caseterm, zero);
        Term smaller = TermFactory.createApp(TheoryFactory.smallerSymbol, caseterm, zero);
        MutableSubstitution empty = new MutableSubstitution();
        ret.add(new ExtraInfo(empty, greater, renaming));
        ret.add(new ExtraInfo(empty, equal, renaming));
        ret.add(new ExtraInfo(empty, smaller, renaming));
        return true;
    }

    private static boolean nonTheoryCasesApplicable(Term caseterm, Renaming renaming, Optional<OutputModule> module) {
        if (!caseterm.isVariable()) {
            module.ifPresent(o -> o.println("Cannot do a case analysis on %a: this term is not a constraint or integer theory term, nor a variable (it has type %a).", Printer.makePrintable(caseterm, renaming), caseterm.queryType()));
            return false;
        }
        if (caseterm.queryType().isProductType()) {
            return true;
        }
        if (caseterm.queryType().isTheoryType()) {
            module.ifPresent(o -> o.println("Cannot do a case analysis on a variable of type %a.", caseterm.queryType()));
            return false;
        }
        return true;
    }

    private static void createConstructorCases(Variable caseterm, Renaming renaming, ProofContext pcontext, ArrayList<ExtraInfo> ret) {
        Set<FunctionSymbol> constructors = pcontext.getConstructors(caseterm.queryType());
        for (FunctionSymbol c : constructors) {
            MutableRenaming ren = renaming.copy();
            Type t = c.queryType();
            ArrayList<Term> args = new ArrayList<Term>(t.queryArity());
            while (t.isArrowType()) {
                Variable x = pcontext.getVariableNamer().chooseDerivative(caseterm, ren, t.subtype(1));
                args.add(x);
                t = t.subtype(2);
            }
            MutableSubstitution subst = new MutableSubstitution();
            subst.extend(caseterm, c.apply(args));
            ret.add(new ExtraInfo(subst, TheoryFactory.trueValue, ren));
        }
    }

    private static void createTupleCase(Variable caseterm, Renaming renaming, ProofContext pcontext, ArrayList<ExtraInfo> ret) {
        Type type = caseterm.queryType();
        int n = type.numberSubtypes();
        ArrayList<Term> parts = new ArrayList<Term>(n);
        MutableRenaming ren = renaming.copy();
        for (int i = 1; i <= n; ++i) {
            Type sub = type.subtype(i);
            Variable x = pcontext.getVariableNamer().chooseDerivative(caseterm, ren, sub);
            parts.add(x);
        }
        MutableSubstitution subst = new MutableSubstitution();
        subst.extend(caseterm, TermFactory.createTuple(parts));
        ret.add(new ExtraInfo(subst, TheoryFactory.trueValue, ren));
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        Renaming renaming = this._state.getTopEquation().getRenaming();
        for (Replaceable x : this._term.freeReplaceables()) {
            if (renaming.getName(x) != null) continue;
            if (x == this._term) {
                module.ifPresent(o -> o.println("Cannot do a case analysis on a variable that does not occur in the equation.", new Object[0]));
            } else {
                module.ifPresent(o -> o.println("Unknown %avariable in case term: \"%a\".", x.queryReplaceableKind() == Replaceable.Kind.METAVAR ? "meta-" : "", this._term));
            }
            return false;
        }
        return true;
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        EquationContext ec = this._state.getTopEquation();
        ArrayList<EquationContext> replacements = new ArrayList<EquationContext>();
        int index = this._state.getLastUsedIndex() + 1;
        for (ExtraInfo info : this._cases) {
            Optional<Term> leftGeq = ec.getLeftGreaterTerm();
            Optional<Term> rightGeq = ec.getRightGreaterTerm();
            if (!leftGeq.isEmpty()) {
                leftGeq = Optional.of(info.subst().substitute(leftGeq.get()));
            }
            if (!rightGeq.isEmpty()) {
                rightGeq = Optional.of(info.subst().substitute(rightGeq.get()));
            }
            Term lhs = info.subst().substitute(ec.getEquation().getLhs());
            Term rhs = info.subst().substitute(ec.getEquation().getRhs());
            Term constraint = info.subst().substitute(ec.getEquation().getConstraint());
            constraint = TheoryFactory.createConjunction(constraint, info.constraint());
            replacements.add(new EquationContext(leftGeq, new Equation(lhs, rhs, constraint), rightGeq, index, info.renaming()));
            ++index;
        }
        return this._state.replaceTopEquation(replacements);
    }

    @Override
    public String commandDescription() {
        Renaming renaming = this._state.getTopEquation().getRenaming();
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        Object[] objectArray = new Object[2];
        objectArray[0] = "case ";
        objectArray[1] = Printer.makePrintable(this._term, renaming);
        printer.add(objectArray);
        return printer.toString();
    }

    @Override
    public void explain(OutputModule module) {
        String applyonwhat = "the instance of";
        Renaming renaming = this._state.getTopEquation().getRenaming();
        if (this._term.queryType().equals(TypeFactory.boolSort)) {
            applyonwhat = "the constraint";
        } else if (this._term.queryType().equals(TypeFactory.intSort)) {
            applyonwhat = "the value of";
        }
        module.println("We apply CASE on %a %a.", applyonwhat, Printer.makePrintable(this._term, renaming));
    }

    private record ExtraInfo(Substitution subst, Term constraint, Renaming renaming) {
    }
}

