/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.position.ArgumentPos;
import charlie.terms.position.Position;
import charlie.terms.replaceable.Renaming;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public final class DeductionContext
extends DeductionStep {
    private boolean _complete;
    private boolean _isBasic;
    private ArrayList<Position> _positions;
    private ArrayList<Pair<Term, Term>> _subtermsAtPositions;

    private DeductionContext(ProofState state, ProofContext context, boolean complete, ArrayList<Position> posses, ArrayList<Pair<Term, Term>> subterms) {
        super(state, context);
        this._complete = complete;
        this._isBasic = false;
        this._positions = posses;
        this._subtermsAtPositions = subterms;
    }

    private DeductionContext(ProofState state, ProofContext context, boolean complete) {
        super(state, context);
        this._complete = complete;
        this._isBasic = true;
        this._positions = new ArrayList();
        this._subtermsAtPositions = new ArrayList();
        Term left = state.getTopEquation().getLhs();
        Term right = state.getTopEquation().getRhs();
        for (int i = 1; i <= left.numberArguments(); ++i) {
            this._positions.add(new ArgumentPos(i, Position.empty));
            this._subtermsAtPositions.add(new Pair<Term, Term>(left.queryArgument(i), right.queryArgument(i)));
        }
    }

    public static DeductionContext createStep(PartialProof proof, Optional<OutputModule> module, List<Position> positions) {
        if (positions.size() == 0) {
            module.ifPresent(o -> o.println("At least one position should be given to CONTEXT.", new Object[0]));
            return null;
        }
        if (positions.size() == 1 && positions.get(0).isEmpty()) {
            module.ifPresent(o -> o.println("Cannot use CONTEXT with the empty position: the step would have no effect.", new Object[0]));
            return null;
        }
        EquationContext ec = DeductionContext.getTopEquation(proof.getProofState(), module);
        ArrayList<Pair<Integer, Position>> posses = DeductionContext.getSorted(positions);
        TreeMap<Integer, Pair<Term, Term>> info = new TreeMap<Integer, Pair<Term, Term>>();
        int chk = DeductionContext.checkPositions(ec.getLhs(), ec.getRhs(), ec.getRenaming(), posses, module, info, new LinkedList<Integer>(), proof.getContext());
        if (chk == 0) {
            return null;
        }
        ArrayList<Pair<Term, Term>> pairs = new ArrayList<Pair<Term, Term>>();
        for (int i = 0; i < posses.size(); ++i) {
            pairs.add(info.get(i));
        }
        return new DeductionContext(proof.getProofState(), proof.getContext(), chk == 2, new ArrayList<Position>(positions), pairs);
    }

    private static ArrayList<Pair<Integer, Position>> getSorted(List<Position> positions) {
        ArrayList<Pair<Integer, Position>> ret = new ArrayList<Pair<Integer, Position>>();
        int i = 0;
        for (Position pos : positions) {
            ret.add(new Pair<Integer, Position>(i++, pos));
        }
        Collections.sort(ret, new Comparator<Pair<Integer, Position>>(){

            @Override
            public int compare(Pair<Integer, Position> pair1, Pair<Integer, Position> pair2) {
                return pair1.snd().compareTo(pair2.snd());
            }
        });
        return ret;
    }

    private static int checkPositions(Term left, Term right, Renaming renaming, List<Pair<Integer, Position>> positions, Optional<OutputModule> module, TreeMap<Integer, Pair<Term, Term>> info, LinkedList<Integer> curpos, ProofContext context) {
        if (!DeductionContext.checkPositionConditions(left, right, renaming, positions, module, curpos)) {
            return 0;
        }
        if (positions.size() == 1 && positions.get(0).snd().isEmpty()) {
            info.put(positions.get(0).fst(), new Pair<Term, Term>(left, right));
            return 2;
        }
        int best = 2;
        int k = 0;
        ArrayList<Pair<Integer, Position>> subposses = new ArrayList<Pair<Integer, Position>>();
        for (int i = 1; i <= left.numberArguments(); ++i) {
            subposses.clear();
            while (k < positions.size() && positions.get(k).snd().queryHead() == i) {
                subposses.add(new Pair<Integer, Position>(positions.get(k).fst(), positions.get(k).snd().queryTail()));
                ++k;
            }
            if (subposses.size() == 0) {
                if (left.queryArgument(i).equals(right.queryArgument(i))) continue;
                Position p = Position.of(curpos, new ArgumentPos(i, Position.empty));
                module.ifPresent(o -> o.println("The subterms at position %a are not the same.", p));
                return 0;
            }
            curpos.add(i);
            int result = DeductionContext.checkPositions(left.queryArgument(i), right.queryArgument(i), renaming, subposses, module, info, curpos, context);
            curpos.removeLast();
            if (result == 0) {
                return 0;
            }
            if (result != 1) continue;
            best = 1;
        }
        if (!(best != 2 || left.isFunctionalTerm() && left.numberArguments() < context.queryRuleArity(left.queryRoot()))) {
            best = 1;
        }
        return best;
    }

    /*
     * Loose catch block
     */
    private static boolean checkPositionConditions(Term left, Term right, Renaming renaming, List<Pair<Integer, Position>> positions, Optional<OutputModule> module, LinkedList<Integer> curpos) {
        if (positions.size() == 1) {
            if (positions.get(0).snd().isEmpty()) {
                return true;
            }
            if (positions.get(0).snd().isFinal()) {
                module.ifPresent(o -> o.println("The context rule cannot be applied with a partial position %a.", Position.of(curpos, (Position)((Pair)positions.get(0)).snd())));
                return false;
            }
        }
        if (!left.queryHead().equals(right.queryHead())) {
            module.ifPresent(o -> o.println("The context rule is not applicable, since the subterms at position %a have different head terms (%a and %a).", Position.of(curpos), Printer.makePrintable(left.queryHead(), renaming), Printer.makePrintable(right.queryHead(), renaming)));
            return false;
        }
        int n = left.numberArguments();
        if (n != right.numberArguments()) {
            module.ifPresent(o -> o.println("The context rule is not applicable, since the subterms at position %a have a different number of arguments.", Position.of(curpos)));
            return false;
        }
        for (Pair<Integer, Position> pair : positions) {
            Position pos = pair.snd();
            if (pos instanceof ArgumentPos) {
                Position position;
                int n2;
                ArgumentPos argumentPos = (ArgumentPos)pos;
                int index = n2 = argumentPos.index();
                Position tail = position = argumentPos.tail();
                if (index <= n) continue;
                module.ifPresent(o -> o.println("There is no position %a: the subterm at position %a %a!", Position.of(curpos, pos), Position.of(curpos), n == 0 ? "has no arguments" : "only has " + n + "arguments"));
                return false;
            }
            if (pos.isFinal()) {
                module.ifPresent(o -> o.println("The given positions are not parallel.", new Object[0]));
                return false;
            }
            module.ifPresent(o -> o.println("Unexpected position: %a.  This does not represent a position in a fully applicative term.", Position.of(curpos, pos)));
            return false;
        }
        return true;
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public static DeductionContext createStep(PartialProof proof, Optional<OutputModule> module, boolean shouldBeComplete) {
        String name;
        ProofState state = proof.getProofState();
        EquationContext ec = DeductionStep.getTopEquation(state, module);
        if (ec == null) {
            return null;
        }
        String string = name = shouldBeComplete ? "semiconstructor" : "context";
        if (!ec.getLhs().queryHead().equals(ec.getRhs().queryHead())) {
            module.ifPresent(o -> o.println("The " + name + " rule cannot be applied, because the two sides of the equation do not have the same head.", new Object[0]));
            return null;
        }
        if (ec.getLhs().numberArguments() != ec.getRhs().numberArguments()) {
            module.ifPresent(o -> o.println("The " + name + " rule cannot be applied, because the two sides of the equation do not have the same number of arguments.", new Object[0]));
            return null;
        }
        boolean isComplete = DeductionContext.checkCompleteness(ec.getEquation(), proof.getContext());
        if (shouldBeComplete && !isComplete) {
            module.ifPresent(o -> o.println("The semiconstructor rule can only be applied if both sides of the equation have a form f s1 ... sn, with f a function symbol and n < ar(f).  (Use \"context\" for the more general form, which does, however, lose completeness in this case.)", new Object[0]));
            return null;
        }
        return new DeductionContext(state, proof.getContext(), isComplete);
    }

    private static boolean checkCompleteness(Equation equation, ProofContext pcontext) {
        int k;
        Term left = equation.getLhs();
        if (!left.isFunctionalTerm()) {
            return false;
        }
        FunctionSymbol f = left.queryRoot();
        int n = left.numberArguments();
        return n < (k = pcontext.queryRuleArity(f));
    }

    public static void storeDifferences(Term s, Term t, ProofContext context, ArrayList<Position> posses, ArrayList<Pair<Term, Term>> pairs) {
        if (!s.queryHead().equals(t.queryHead()) || s.numberArguments() != t.numberArguments()) {
            posses.add(Position.empty);
            pairs.add(new Pair<Term, Term>(s, t));
            return;
        }
        if (!s.isFunctionalTerm() || s.numberArguments() >= context.queryRuleArity(s.queryRoot())) {
            if (!s.equals(t)) {
                posses.add(Position.empty);
                pairs.add(new Pair<Term, Term>(s, t));
            }
            return;
        }
        int n = s.numberArguments();
        int k = posses.size();
        for (int i = 1; i <= n; ++i) {
            DeductionContext.storeDifferences(s.queryArgument(i), t.queryArgument(i), context, posses, pairs);
            if (posses.size() <= k) continue;
            for (int j = k; j < posses.size(); ++j) {
                posses.set(j, new ArgumentPos(i, posses.get(j)));
            }
            k = posses.size();
        }
    }

    public boolean isComplete() {
        return this._complete;
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        return true;
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        ArrayList<EquationContext> neweqs = new ArrayList<EquationContext>();
        Term constr = this._equ.getEquation().getConstraint();
        int index = this._state.getLastUsedIndex();
        for (int i = this._subtermsAtPositions.size() - 1; i >= 0; --i) {
            Equation newequation = new Equation(this._subtermsAtPositions.get(i).fst(), this._subtermsAtPositions.get(i).snd(), constr);
            neweqs.add(this._equ.replace(newequation, ++index));
        }
        ProofState state = this._state;
        if (!this._complete) {
            state = state.setIncomplete(this._equ.getIndex());
        }
        return state.replaceTopEquation(neweqs);
    }

    @Override
    public String commandDescription() {
        if (this._isBasic) {
            if (this._complete) {
                return "semiconstructor";
            }
            return "context";
        }
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        printer.add("context");
        for (Position pos : this._positions) {
            printer.add(" ");
            printer.add(pos);
        }
        return printer.toString();
    }

    @Override
    public void explain(OutputModule module) {
        if (!this._complete || !this._isBasic) {
            module.println("We apply CONTEXT to %a, splitting the immediate arguments into separate equations.%a", this._equ.getName(), this._state.getIncompleteEquations().contains(this._equ.getIndex()) ? "" : (this._complete ? "  We preserve the completeness flag." : "  We lose the completeness flag."));
            return;
        }
        FunctionSymbol f = this._equ.getEquation().getLhs().queryRoot();
        if (this._pcontext.getTRS().isDefined(f) || f.toCalculationSymbol() != null) {
            module.println("We apply SEMICONSTRUCTOR to %a, since the rule arity of %a is %a and only %a arguments are present.", this._equ.getName(), f, this._pcontext.queryRuleArity(f), this._equ.getEquation().getLhs().numberArguments());
        } else {
            module.println("We apply SEMICONSTRUCTOR to %a since %a is a constructor symbol.", this._equ.getName(), f.queryName());
        }
    }
}

