/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.substitution.Substitution;
import charlie.terms.Term;
import charlie.theorytranslation.TermAnalyser;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;

public final class DeductionDelete
extends DeductionStep {
    private boolean _bothSidesEqual;

    private DeductionDelete(ProofState state, ProofContext context, boolean equalsides) {
        super(state, context);
        this._bothSidesEqual = equalsides;
    }

    public static DeductionDelete createStep(PartialProof proof, Optional<OutputModule> module) {
        ProofState state = proof.getProofState();
        EquationContext ec = DeductionStep.getTopEquation(state, module);
        if (ec == null) {
            return null;
        }
        if (ec.getLhs().equals(ec.getRhs())) {
            return new DeductionDelete(state, proof.getContext(), true);
        }
        return new DeductionDelete(state, proof.getContext(), false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean verify(Optional<OutputModule> module) {
        if (this._bothSidesEqual) {
            return true;
        }
        Term constraint = this._equ.getEquation().getConstraint();
        TermAnalyser.Result result = TermAnalyser.satisfy(constraint, Settings.smtSolver);
        Objects.requireNonNull(result);
        TermAnalyser.Result result2 = result;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TermAnalyser.Result.MAYBE.class, TermAnalyser.Result.YES.class, TermAnalyser.Result.NO.class}, (Object)result2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                String reason;
                TermAnalyser.Result.MAYBE mAYBE = (TermAnalyser.Result.MAYBE)result2;
                try {
                    String string;
                    reason = string = mAYBE.reason();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                this.println(module, "The DELETE rule is not obviously applicable: the left- and right-hand side are not the same, and checking satisfiability returns MAYBE (%a)", reason);
                return false;
            }
            case 1: {
                Substitution val;
                TermAnalyser.Result.YES yES = (TermAnalyser.Result.YES)result2;
                {
                    Substitution substitution;
                    val = substitution = yES.subst();
                }
                this.println(module, "The DELETE rule is not applicable: the left- and right-hand side are not the same, and the constraint is satisfiable using substitution %a.", Printer.makePrintable(val, this._equ.getRenaming(), this._equ.getRenaming()));
                return false;
            }
            case 2: 
        }
        TermAnalyser.Result.NO nO = (TermAnalyser.Result.NO)result2;
        return true;
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        return this._state.deleteTopEquation();
    }

    @Override
    public String commandDescription() {
        return "delete";
    }

    @Override
    public void explain(OutputModule module) {
        module.println("We apply DELETION to %a because %a.  Thus, we may remove this equation from the proof state.", this._equ.getName(), this._bothSidesEqual ? "both sides are equal" : "the constraint is unsatisfiable");
    }
}

