/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import charlie.types.Type;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.HashSet;
import java.util.Optional;

public class DeductionDisproveRoot
extends DeductionStep {
    private FunctionSymbol _left;
    private FunctionSymbol _right;

    protected DeductionDisproveRoot(ProofState state, ProofContext context, FunctionSymbol left, FunctionSymbol right) {
        super(state, context);
        this._left = left;
        this._right = right;
    }

    @Override
    public final ProofState tryApply(Optional<OutputModule> module) {
        return ProofState.getContradictionState();
    }

    @Override
    public final String commandDescription() {
        return "disprove root";
    }

    @Override
    public boolean verify(Optional<OutputModule> m) {
        return true;
    }

    @Override
    public void explain(OutputModule module) {
        String extra1 = this._left.queryType().equals(this._equ.getEquation().getLhs().queryType()) ? "" : "(...)";
        String extra2 = this._right.queryType().equals(this._equ.getEquation().getRhs().queryType()) ? "" : "(...)";
        module.println("We apply DISPROVE to %a, which succeeds because the sides can be instantiated to distinct semi-constructor terms; respectively %a%a and %a%a.", this._equ.getName(), this._left.queryName(), extra1, this._right.queryName(), extra2);
    }

    public static DeductionDisproveRoot createStep(PartialProof proof, Optional<OutputModule> m) {
        ProofState state = proof.getProofState();
        ProofContext context = proof.getContext();
        EquationContext ec = DeductionDisproveRoot.getTopEquation(proof.getProofState(), m);
        if (ec == null) {
            return null;
        }
        Term left = ec.getLhs();
        Term right = ec.getRhs();
        if (state.getIncompleteEquations().contains(ec.getIndex())) {
            m.ifPresent(o -> o.println("DISPROVE can only be applied on complete equation contexts.", new Object[0]));
            return null;
        }
        Pair<FunctionSymbol, FunctionSymbol> p = DeductionDisproveRoot.checkDifferentSemiconstructors(left, right, context);
        if (p == null) {
            if (left.isTheoryTerm() && right.isTheoryTerm() && left.queryType().isBaseType() && left.queryType().isTheoryType()) {
                m.ifPresent(o -> o.println("This case should be handled using DISPROVE THEORY rather than DISPROVE ROOT.", new Object[0]));
            } else if (left.isFunctionalTerm() && right.isFunctionalTerm() && left.queryRoot().equals(right.queryRoot())) {
                m.ifPresent(o -> o.println("Both sides have the same root symbol.", new Object[0]));
            } else if (left.isFunctionalTerm() && right.isFunctionalTerm()) {
                m.ifPresent(o -> o.println("Disprove can only be applied (on non-theory terms) when neither side is a functional term with enough arguments to apply a rule.", new Object[0]));
            } else {
                m.ifPresent(o -> o.println("There is no substitution over the known alphabet that would instantiate the left- and right-hand to different semi-constructor terms.", new Object[0]));
            }
            return null;
        }
        return new DeductionDisproveRoot(state, context, p.fst(), p.snd());
    }

    public static Pair<FunctionSymbol, FunctionSymbol> checkDifferentSemiconstructors(Term left, Term right, ProofContext context) {
        if (left.queryHead().equals(right.queryHead())) {
            return null;
        }
        FunctionSymbol f = null;
        FunctionSymbol g = null;
        if (left.isFunctionalTerm()) {
            f = left.queryRoot();
            if (left.numberArguments() >= context.queryRuleArity(f)) {
                return null;
            }
        }
        if (right.isFunctionalTerm()) {
            g = right.queryRoot();
            if (right.numberArguments() >= context.queryRuleArity(g)) {
                return null;
            }
        }
        if (f != null && g != null) {
            return new Pair<FunctionSymbol, FunctionSymbol>(f, g);
        }
        if (f == null) {
            f = DeductionDisproveRoot.findSemiConstructor(context, left.queryHead().queryType(), left.numberArguments(), g);
        }
        if (g == null) {
            g = DeductionDisproveRoot.findSemiConstructor(context, right.queryHead().queryType(), right.numberArguments(), f);
        }
        if (f != null && g != null) {
            return new Pair<FunctionSymbol, FunctionSymbol>(f, g);
        }
        return null;
    }

    private static FunctionSymbol findSemiConstructor(ProofContext context, Type otype, int numargs, FunctionSymbol h) {
        HashSet<FunctionSymbol> set = new HashSet<FunctionSymbol>();
        set.addAll(TheoryFactory.queryAllCalculationSymbols());
        set.addAll(context.getTRS().queryAlphabet().getSymbols());
        int oar = otype.queryArity();
        for (FunctionSymbol f : set) {
            Type t;
            int k;
            if (f == h || (k = (t = f.queryType()).queryArity()) < oar) continue;
            int n = k - oar;
            if (context.queryRuleArity(f) <= n + numargs) continue;
            for (int i = 0; i < n; ++i) {
                t = t.subtype(2);
            }
            if (!t.equals(otype)) continue;
            return f;
        }
        return null;
    }
}

