/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.substitution.Substitution;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import charlie.terms.Value;
import charlie.theorytranslation.TermAnalyser;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.Optional;

public class DeductionDisproveTheory
extends DeductionStep {
    protected Substitution _substitution;

    protected DeductionDisproveTheory(ProofState state, ProofContext context, Substitution subst) {
        super(state, context);
        this._substitution = subst;
    }

    public static DeductionDisproveTheory createStep(PartialProof proof, Optional<OutputModule> m, Substitution subst) {
        ProofState state = proof.getProofState();
        ProofContext context = proof.getContext();
        EquationContext ec = DeductionDisproveTheory.getTopEquation(proof.getProofState(), m);
        if (ec == null) {
            return null;
        }
        if (state.getIncompleteEquations().contains(ec.getIndex())) {
            m.ifPresent(o -> o.println("DISPROVE can only be applied on complete equation contexts.", new Object[0]));
            return null;
        }
        Term left = subst.substitute(ec.getLhs());
        Term right = subst.substitute(ec.getRhs());
        Term constr = subst.substitute(ec.getConstraint());
        if (!(left.isGround() && right.isGround() && constr.isGround() && constr.isTheoryTerm())) {
            m.ifPresent(o -> o.println("The substitution does not map all variables in the equation to ground theory terms.", new Object[0]));
            return null;
        }
        if (!left.isTheoryTerm() || !right.isTheoryTerm() || !left.queryType().isBaseType() | !right.queryType().isBaseType()) {
            m.ifPresent(o -> o.println("The left- and right-hand sides of the equation do not have base type.", new Object[0]));
            return null;
        }
        return new DeductionDisproveTheory(state, context, subst);
    }

    @Override
    public final ProofState tryApply(Optional<OutputModule> module) {
        return ProofState.getContradictionState();
    }

    @Override
    public final String commandDescription() {
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        printer.add("disprove theory with ");
        Object[] objectArray = new Object[1];
        objectArray[0] = Printer.makePrintable(this._substitution, this._equ.getRenaming(), this._equ.getRenaming());
        printer.add(objectArray);
        return printer.toString();
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        Value constraint = TermAnalyser.evaluate(this._substitution.substitute(this._equ.getConstraint()));
        Value l = TermAnalyser.evaluate(this._substitution.substitute(this._equ.getLhs()));
        Value r = TermAnalyser.evaluate(this._substitution.substitute(this._equ.getRhs()));
        if (!constraint.equals(TheoryFactory.trueValue)) {
            this.println(module, "DISPROVE cannot be applied with the given substitution %a, since the instantiated constraint evaluates to false.", Printer.makePrintable(this._substitution, this._equ.getRenaming(), this._equ.getRenaming()));
            return false;
        }
        if (l.equals(r)) {
            this.println(module, "DISPROVE cannot be applied with the given substitution, since the instantiated left- and right-hand side both evaluate to %a.", l);
            return false;
        }
        return true;
    }

    @Override
    public void explain(OutputModule module) {
        Value constraint = TermAnalyser.evaluate(this._substitution.substitute(this._equ.getConstraint()));
        Value l = TermAnalyser.evaluate(this._substitution.substitute(this._equ.getLhs()));
        Value r = TermAnalyser.evaluate(this._substitution.substitute(this._equ.getRhs()));
        module.println("We apply DISPROVE to %a, which succeeds because under the substitution %a, the constraint %a evaluates to true, while the sides of the equation can be calculated to %a and %a respectively.", this._equ.getName(), Printer.makePrintable(this._substitution, this._equ.getRenaming(), this._equ.getRenaming()), Printer.makePrintable(this._equ.getEquation().getConstraint(), this._equ.getRenaming()), l, r);
    }
}

