/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import charlie.terms.position.Position;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.theorytranslation.TermSmtTranslator;
import charlie.util.Pair;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class DeductionEqdelete
extends DeductionStep {
    private Term _required;

    private DeductionEqdelete(ProofState state, ProofContext context, Term required) {
        super(state, context);
        this._required = required;
    }

    public static DeductionEqdelete createStep(PartialProof proof, Optional<OutputModule> module) {
        ProofState state = proof.getProofState();
        EquationContext ec = DeductionStep.getTopEquation(state, module);
        if (ec == null) {
            return null;
        }
        Term req = DeductionEqdelete.createMainStep(ec.getLhs(), ec.getRhs(), ec.getConstraint(), module, ec.getRenaming());
        if (req == null) {
            return null;
        }
        return new DeductionEqdelete(state, proof.getContext(), req);
    }

    public static boolean checkApplicability(Term left, Term right, Term constraint) {
        MutableRenaming renaming = Renaming.createEmptyRenaming(Set.of());
        Term requirement = DeductionEqdelete.createMainStep(left, right, constraint, Optional.empty(), renaming);
        if (requirement == null) {
            return false;
        }
        TermSmtTranslator translator = new TermSmtTranslator();
        translator.requireImplication(constraint, requirement);
        return Settings.smtSolver.checkValidity(translator.queryProblem());
    }

    private static Term createMainStep(Term left, Term right, Term constraint, Optional<OutputModule> module, Renaming renaming) {
        ArrayList<Pair<Term, Position>> posRight;
        ArrayList<Pair<Term, Position>> posLeft = DeductionEqdelete.getSubtermInfo(left);
        if (!DeductionEqdelete.checkSamePositions(posLeft, posRight = DeductionEqdelete.getSubtermInfo(right), module)) {
            return null;
        }
        ArrayList<Pair<Term, Term>> parts = new ArrayList<Pair<Term, Term>>();
        int k = posLeft.size();
        for (int i = 0; i < k; ++i) {
            Term a = posLeft.get(i).fst();
            Term b = posRight.get(i).fst();
            boolean ok = !(!a.isVariable() && !a.isConstant() || !b.isVariable() && !b.isConstant()) ? DeductionEqdelete.checkDifferencesAreTheory(a, b, parts, renaming, module) : DeductionEqdelete.checkSameShape(a, b, renaming, module);
            if (ok) continue;
            return null;
        }
        if (parts.size() == 0) {
            module.ifPresent(o -> o.println("No subterms to be equated; use DELETION instead!", new Object[0]));
            return null;
        }
        return DeductionEqdelete.createEqualityConstraint(parts);
    }

    private static ArrayList<Pair<Term, Position>> getSubtermInfo(Term t) {
        List<Pair<Term, Position>> info = t.querySubterms();
        if (info instanceof ArrayList) {
            ArrayList a = (ArrayList)info;
            return a;
        }
        return new ArrayList<Pair<Term, Position>>(info);
    }

    private static boolean checkSamePositions(ArrayList<Pair<Term, Position>> left, ArrayList<Pair<Term, Position>> right, Optional<OutputModule> module) {
        int k = left.size();
        if (k != right.size()) {
            module.ifPresent(o -> o.println("There is no suitable context for both sides: they have a different number of subterms (note that you can only use EQ-DELETE if the terms to be equated are variables or values -- not more sophisticated theory terms).", new Object[0]));
            return false;
        }
        for (int i = 0; i < k; ++i) {
            if (left.get(i).snd().equals(right.get(i).snd())) continue;
            module.ifPresent(o -> o.println("There is no suitable context for both sides: their position lists are not the same.", new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean checkSameShape(Term left, Term right, Renaming renaming, Optional<OutputModule> module) {
        if (left.isApplication()) {
            if (right.isApplication() && left.numberArguments() == right.numberArguments() && left.queryHead().equals(right.queryHead())) {
                return true;
            }
        } else if (left.isTuple()) {
            if (right.isTuple() && left.numberTupleArguments() == right.numberTupleArguments()) {
                return true;
            }
        } else {
            if (left.isVariable() || left.isConstant()) {
                module.ifPresent(o -> o.println("Subterm %a is a kind of term that is not currently supported in the rewriting induction module (at least not in EQ-DELETION).", Printer.makePrintable(right, renaming)));
                return false;
            }
            module.ifPresent(o -> o.println("Subterm %a is a kind of term that is not currently supported in the rewriting induction module (at least not in EQ-DELETION).", Printer.makePrintable(left, renaming)));
            return false;
        }
        module.ifPresent(o -> o.println("There is no suitable context for both sides: subterms %a and %a cannot be equated.", Printer.makePrintable(left, renaming), Printer.makePrintable(right, renaming)));
        return false;
    }

    private static boolean checkDifferencesAreTheory(Term left, Term right, ArrayList<Pair<Term, Term>> parts, Renaming renaming, Optional<OutputModule> module) {
        if (left.equals(right)) {
            return true;
        }
        if (left.isConstant() && right.isConstant()) {
            String kind = left.isValue() ? "values" : "constants";
            module.ifPresent(o -> o.println("Failed to equate distinct %a (%a and %a).", kind, Printer.makePrintable(left, renaming), Printer.makePrintable(right, renaming)));
            return false;
        }
        if (!left.isVariable() && !left.isValue() || !right.isVariable() && !right.isValue()) {
            Term bad = left.isVariable() || left.isValue() ? right : left;
            module.ifPresent(o -> o.println("Failed to equate %a and %a: they cannot be moved into the constraint because %a is not a theory term.", Printer.makePrintable(left, renaming), Printer.makePrintable(right, renaming), Printer.makePrintable(bad, renaming)));
            return false;
        }
        if (!left.queryType().isTheoryType() || !left.queryType().isBaseType()) {
            module.ifPresent(o -> o.println("Failed to equate %a and %a: they cannot be moved into the constraint because the type %a is not a theory sort.", Printer.makePrintable(left, renaming), Printer.makePrintable(right, renaming), left.queryType()));
            return false;
        }
        parts.add(new Pair<Term, Term>(left, right));
        return true;
    }

    private static Term createEqualityConstraint(ArrayList<Pair<Term, Term>> parts) {
        Term ret = TheoryFactory.createValue(true);
        for (Pair<Term, Term> pair : parts) {
            Term c = TheoryFactory.createEquality(pair.fst(), pair.snd());
            ret = TheoryFactory.createConjunction(ret, c);
        }
        return ret;
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        TermSmtTranslator translator = new TermSmtTranslator();
        translator.requireImplication(this._equ.getEquation().getConstraint(), this._required);
        if (Settings.smtSolver.checkValidity(translator.queryProblem())) {
            return true;
        }
        Renaming renaming = this._equ.getRenaming();
        module.ifPresent(o -> o.println("The EQ-DELETION rule is not obviously applicable: I could not prove that %a %{Vdash} %a.", Printer.makePrintable(this._equ.getEquation().getConstraint(), renaming), Printer.makePrintable(this._required, renaming)));
        return false;
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        return this._state.deleteTopEquation();
    }

    @Override
    public String commandDescription() {
        return "eq-delete";
    }

    @Override
    public void explain(OutputModule module) {
        Renaming renaming = this._equ.getRenaming();
        module.println("We observe that %a %{Vdash} %a, and may therefore apply EQ-DELETION to remove %a from the proof state.", Printer.makePrintable(this._equ.getEquation().getConstraint(), renaming), Printer.makePrintable(this._required, renaming), this._equ.getName());
    }
}

