/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Stack;

public final class DeductionGeneraliseDrop
extends DeductionStep {
    private Term _newConstraint;
    private Term _dropped;

    private DeductionGeneraliseDrop(ProofState state, ProofContext context, Term newconstr, Term dropped) {
        super(state, context);
        this._newConstraint = newconstr;
        this._dropped = dropped;
    }

    private static ArrayList<Term> split(Term constraint) {
        ArrayList<Term> ret = new ArrayList<Term>();
        Stack<Term> todo = new Stack<Term>();
        todo.push(constraint);
        while (!todo.isEmpty()) {
            Term term = (Term)todo.pop();
            while (term.isFunctionalTerm() && term.queryRoot().equals(TheoryFactory.andSymbol) && term.numberArguments() == 2) {
                todo.push(term.queryArgument(2));
                term = term.queryArgument(1);
            }
            ret.add(term);
        }
        return ret;
    }

    public static DeductionGeneraliseDrop createStep(PartialProof proof, Optional<OutputModule> module, Term dropme) {
        ProofState state = proof.getProofState();
        EquationContext ec = DeductionGeneraliseDrop.getTopEquation(state, module);
        if (ec == null) {
            return null;
        }
        ArrayList<Term> originalComponents = DeductionGeneraliseDrop.split(ec.getConstraint());
        ArrayList<Term> remove = DeductionGeneraliseDrop.split(dropme);
        for (Term todrop : remove) {
            boolean found = false;
            for (int i = 0; i < originalComponents.size() && !found; ++i) {
                if (originalComponents.get(i) == null || !originalComponents.get(i).equals(todrop)) continue;
                originalComponents.set(i, null);
                found = true;
            }
            if (found) continue;
            module.ifPresent(o -> o.println("No such subterm in the constraint: %a.", Printer.makePrintable(todrop, ec.getRenaming())));
            return null;
        }
        Term updated = TheoryFactory.trueValue;
        for (Term component : originalComponents) {
            if (component == null) continue;
            updated = TheoryFactory.createConjunction(updated, component);
        }
        return new DeductionGeneraliseDrop(state, proof.getContext(), updated, dropme);
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        return true;
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        Equation oldEquation = this._state.getTopEquation().getEquation();
        Equation newEquation = new Equation(oldEquation.getLhs(), oldEquation.getRhs(), this._newConstraint);
        int newIndex = this._state.getLastUsedIndex() + 1;
        return this._state.replaceTopEquation(this._state.getTopEquation().replace(newEquation, newIndex)).setIncomplete(newIndex);
    }

    @Override
    public String commandDescription() {
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        printer.add("generalise drop ");
        Object[] objectArray = new Object[1];
        objectArray[0] = Printer.makePrintable(this._dropped, this._state.getTopEquation().getRenaming());
        printer.add(objectArray);
        return printer.toString();
    }

    @Override
    public void explain(OutputModule module) {
        module.println("We apply GENERALISE to replace the constraint of %a by %a.", this._equ.getName(), Printer.makePrintable(this._newConstraint, this._state.getTopEquation().getRenaming()));
    }
}

