/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.Variable;
import charlie.terms.position.Position;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import cora.rwinduction.engine.VariableNamer;
import java.util.ArrayList;
import java.util.Optional;

public final class DeductionGeneraliseSubterm
extends DeductionStep {
    private Term _replaced;
    private Variable _replacement;
    private Renaming _renaming;
    private Equation _newEquation;

    private DeductionGeneraliseSubterm(ProofState state, ProofContext context, Term replaced, Variable replacement, Renaming renaming, Term newLeft, Term newRight, Term newConstr) {
        super(state, context);
        this._replaced = replaced;
        this._replacement = replacement;
        this._renaming = renaming;
        this._newEquation = new Equation(newLeft, newRight, newConstr);
    }

    public static DeductionGeneraliseSubterm createStep(PartialProof proof, Optional<OutputModule> module, Term subterm, String newvarname) {
        ProofState state = proof.getProofState();
        ProofContext context = proof.getContext();
        EquationContext ec = DeductionGeneraliseSubterm.getTopEquation(state, module);
        if (ec == null) {
            return null;
        }
        ArrayList<Position> leftPosses = DeductionGeneraliseSubterm.getSubtermPositions(ec.getLhs(), subterm);
        ArrayList<Position> rightPosses = DeductionGeneraliseSubterm.getSubtermPositions(ec.getRhs(), subterm);
        ArrayList<Position> constrPosses = DeductionGeneraliseSubterm.getSubtermPositions(ec.getConstraint(), subterm);
        if (leftPosses.isEmpty() && rightPosses.isEmpty() && constrPosses.isEmpty()) {
            module.ifPresent(o -> o.println("No such subterm in the equation: %a", Printer.makePrintable(subterm, state.getTopEquation().getRenaming())));
            return null;
        }
        VariableNamer.VariableInfo info = context.getVariableNamer().getVariableInfo(newvarname);
        Variable x = TermFactory.createVar(info.basename(), subterm.queryType());
        MutableRenaming renaming = state.getTopEquation().getRenaming().copy();
        if (!renaming.setName(x, newvarname)) {
            if (renaming.getReplaceable(newvarname) != null) {
                module.ifPresent(o -> o.println("The variable name %a is not fresh.", newvarname));
            } else {
                module.ifPresent(o -> o.println("The name %a is not a legal variable name.", newvarname));
            }
            return null;
        }
        Term left = DeductionGeneraliseSubterm.replacePositions(ec.getLhs(), leftPosses, x);
        Term right = DeductionGeneraliseSubterm.replacePositions(ec.getRhs(), rightPosses, x);
        Term cstr = DeductionGeneraliseSubterm.replacePositions(ec.getConstraint(), constrPosses, x);
        return new DeductionGeneraliseSubterm(state, context, subterm, x, renaming, left, right, cstr);
    }

    private static ArrayList<Position> getSubtermPositions(Term term, Term subterm) {
        ArrayList<Position> ret = new ArrayList<Position>();
        term.visitSubterms((s, p) -> {
            if (s.equals(subterm)) {
                ret.add((Position)p);
            }
        });
        return ret;
    }

    private static Term replacePositions(Term term, ArrayList<Position> posses, Term replacement) {
        for (Position pos : posses) {
            term = term.replaceSubterm(pos, replacement);
        }
        return term;
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        return true;
    }

    private EquationContext makeNewEquationContext() {
        Optional<Term> rightGreater;
        EquationContext old = this._state.getTopEquation();
        Optional<Term> leftGreater = old.getLeftGreaterTerm();
        if (!(leftGreater.isEmpty() || old.getEquation().getLhs() == this._newEquation.getLhs() && old.getEquation().getConstraint() == this._newEquation.getConstraint() && DeductionGeneraliseSubterm.getSubtermPositions(leftGreater.get(), this._replaced).isEmpty())) {
            leftGreater = Optional.of(this._newEquation.getLhs());
        }
        if (!((rightGreater = old.getRightGreaterTerm()).isEmpty() || old.getEquation().getRhs() == this._newEquation.getRhs() && old.getEquation().getConstraint() == this._newEquation.getConstraint() && DeductionGeneraliseSubterm.getSubtermPositions(rightGreater.get(), this._replaced).isEmpty())) {
            rightGreater = Optional.of(this._newEquation.getRhs());
        }
        return new EquationContext(leftGreater, this._newEquation, rightGreater, this._state.getLastUsedIndex() + 1, this._renaming);
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        EquationContext ec = this.makeNewEquationContext();
        return this._state.replaceTopEquation(ec).setIncomplete(ec.getIndex());
    }

    @Override
    public String commandDescription() {
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        printer.add("generalise subterm ");
        Object[] objectArray = new Object[1];
        objectArray[0] = Printer.makePrintable(this._replaced, this._renaming);
        printer.add(objectArray);
        printer.add(" as ", this._renaming.getName(this._replacement));
        return printer.toString();
    }

    @Override
    public void explain(OutputModule module) {
        module.println("We apply GENERALISE to replace the equation context %a by %a.", this._equ.getName(), this.makeNewEquationContext());
    }
}

