/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.substitution.Substitution;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.Variable;
import charlie.terms.position.ArgumentPos;
import charlie.terms.position.FinalPos;
import charlie.terms.position.Position;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.EquationPosition;
import cora.rwinduction.engine.Hypothesis;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import cora.rwinduction.engine.deduction.ConstrainedSimplifier;
import java.util.Optional;
import java.util.Set;

public final class DeductionHdelete
extends DeductionStep {
    private ConstrainedSimplifier _simplifier;
    private EquationPosition _position;
    private String _hypothesisName;
    private boolean _inversed;

    private DeductionHdelete(ProofState state, ProofContext context, String hypoName, boolean inverse, EquationPosition pos, ConstrainedSimplifier s) {
        super(state, context);
        this._simplifier = s;
        this._position = pos;
        this._hypothesisName = hypoName;
        this._inversed = inverse;
    }

    public static DeductionHdelete createStep(PartialProof proof, Optional<OutputModule> m, Hypothesis hypo, boolean inverse, EquationPosition pos, Substitution subst) {
        EquationContext original = DeductionHdelete.getTopEquation(proof.getProofState(), m);
        if (original == null) {
            return null;
        }
        ConstrainedSimplifier simpl = new ConstrainedSimplifier(inverse ? hypo.getRhs() : hypo.getLhs(), inverse ? hypo.getLhs() : hypo.getRhs(), hypo.getConstraint(), hypo.getRenaming(), subst);
        if (!simpl.matchSubterm(original.getEquation(), pos, m, "induction hypothesis")) {
            return null;
        }
        if (!DeductionHdelete.matchRightSubterm(original.getEquation(), pos, simpl, m)) {
            return null;
        }
        simpl.matchEqualitiesInConstraint(original.getConstraint());
        Position p = pos.queryPosition();
        if (!DeductionHdelete.sameContexts(original.getEquation(), p)) {
            m.ifPresent(o -> DeductionHdelete.printBadContextError(original, p, o));
            return null;
        }
        if (!DeductionHdelete.resultingOrderingRequirementOK(original, p, m)) {
            return null;
        }
        return new DeductionHdelete(proof.getProofState(), proof.getContext(), hypo.getName() + (inverse ? "^{-1}" : ""), inverse, pos, simpl);
    }

    public static boolean checkApplicability(Optional<Term> leftbound, Term left, Term right, Optional<Term> rightbound, Term constraint, Hypothesis hypo, boolean inverse) {
        if (leftbound.isPresent() && leftbound.get().equals(left) && rightbound.isPresent() && rightbound.get().equals(right)) {
            return false;
        }
        ConstrainedSimplifier simpl = new ConstrainedSimplifier(inverse ? hypo.getRhs() : hypo.getLhs(), inverse ? hypo.getLhs() : hypo.getRhs(), hypo.getConstraint(), hypo.getRenaming(), null);
        if (simpl.matchLeft(left) != null) {
            return false;
        }
        if (simpl.matchRight(right) != null) {
            return false;
        }
        simpl.matchEqualitiesInConstraint(constraint);
        if (simpl.constraintIsTrue()) {
            return true;
        }
        MutableRenaming renaming = new MutableRenaming(Set.of());
        return simpl.canReduceCtermWithConstraint(constraint, Settings.smtSolver, renaming, Optional.empty(), "induction hypothesis");
    }

    private static boolean matchRightSubterm(Equation eq, EquationPosition leftpos, ConstrainedSimplifier simpl, Optional<OutputModule> m) {
        EquationPosition.Side side = switch (leftpos.querySide()) {
            default -> throw new MatchException(null, null);
            case EquationPosition.Side.Left -> EquationPosition.Side.Right;
            case EquationPosition.Side.Right -> EquationPosition.Side.Left;
        };
        String sd = switch (side) {
            default -> throw new MatchException(null, null);
            case EquationPosition.Side.Left -> "left";
            case EquationPosition.Side.Right -> "right";
        };
        Term othersub = eq.querySubterm(new EquationPosition(side, leftpos.queryPosition()));
        if (othersub == null) {
            m.ifPresent(o -> o.println("The %a-hand side of the equation does not have a position %a.", sd, leftpos.queryPosition()));
            return false;
        }
        if (simpl.matchRight(othersub) != null) {
            m.ifPresent(o -> o.println("The induction hypothesis does not match the %a-hand side of the equation.", sd));
            return false;
        }
        return true;
    }

    private static boolean sameContexts(Equation equation, Position pos) {
        int i;
        Term left = equation.getLhs();
        Term right = equation.getRhs();
        while (pos instanceof ArgumentPos) {
            ArgumentPos p = (ArgumentPos)pos;
            if (!(left.isApplication() && right.isApplication() && left.numberArguments() == right.numberArguments() && left.queryHead().equals(right.queryHead()))) {
                return false;
            }
            int index = p.queryHead();
            for (i = 1; i <= left.numberArguments(); ++i) {
                if (i == index || left.queryArgument(i).equals(right.queryArgument(i))) continue;
                return false;
            }
            left = left.queryArgument(index);
            right = right.queryArgument(index);
            pos = p.queryTail();
        }
        if (pos.isEmpty()) {
            return true;
        }
        if (pos instanceof FinalPos) {
            FinalPos f = (FinalPos)pos;
            if (!left.isApplication() || !right.isApplication()) {
                return false;
            }
            int chop = f.queryChopCount();
            if (left.numberArguments() < chop || right.numberArguments() < chop) {
                return false;
            }
            for (i = 0; i < chop; ++i) {
                if (left.queryArgument(left.numberArguments() - i).equals(right.queryArgument(right.numberArguments() - i))) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Positions may only be argument or final positions.");
    }

    private static void printBadContextError(EquationContext ec, Position pos, OutputModule o) {
        Term left = ec.getEquation().getLhs();
        Term right = ec.getEquation().getRhs();
        MutableRenaming renaming = ec.getRenaming().copy();
        Term subterm = left.querySubterm(pos);
        Variable x = TermFactory.createVar("[]", subterm.queryType());
        left = left.replaceSubterm(pos, x);
        right = right.replaceSubterm(pos, x);
        if (!(renaming.setName(x, "[]") || renaming.setName(x, "[ ]") || renaming.setName(x, "BOX") || renaming.setName(x, "#"))) {
            renaming.setName(x, "CONTEXT");
        }
        o.println("The two sides have different contexts: %a versus %a.", Printer.makePrintable(left, (Renaming)renaming), Printer.makePrintable(right, (Renaming)renaming));
    }

    private static boolean resultingOrderingRequirementOK(EquationContext original, Position pos, Optional<OutputModule> m) {
        if (original.getLeftGreaterTerm().isEmpty() || original.getRightGreaterTerm().isEmpty() || !pos.isEmpty()) {
            return true;
        }
        if (!original.getLeftGreaterTerm().get().equals(original.getEquation().getLhs()) || !original.getRightGreaterTerm().get().equals(original.getEquation().getRhs())) {
            return true;
        }
        m.ifPresent(o -> o.println("Cannot apply an induction hypothesis at position %a when both bounding terms are the same as the equation terms.", pos));
        return false;
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        if (this._simplifier.constraintIsTrue()) {
            return true;
        }
        return this._simplifier.canReduceCtermWithConstraint(this._equ.getConstraint(), Settings.smtSolver, this._equ.getRenaming(), module, "induction hypothesis");
    }

    @Override
    protected ProofState tryApply(Optional<OutputModule> module) {
        return this._state.deleteTopEquation();
    }

    @Override
    public String commandDescription() {
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        printer.add("hdelete ", this._hypothesisName, " ", this._position, " with ", this._simplifier.substitutionPrintable(this._equ.getRenaming()));
        return printer.toString();
    }

    @Override
    public void explain(OutputModule module) {
        module.println("We apply HDELETE to %a with induction hypothesis %a and substitution %a.", this._equ.getName(), this._hypothesisName, this._simplifier.substitutionPrintable(this._equ.getRenaming()));
    }
}

