/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.substitution.Substitution;
import charlie.terms.Term;
import charlie.terms.replaceable.Renaming;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.EquationPosition;
import cora.rwinduction.engine.Hypothesis;
import cora.rwinduction.engine.OrdReq;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import cora.rwinduction.engine.deduction.ConstrainedSimplifier;
import java.util.ArrayList;
import java.util.Optional;

public final class DeductionHypothesis
extends DeductionStep {
    private ConstrainedSimplifier _simplifier;
    private EquationPosition _position;
    private String _hypothesisName;
    private boolean _inversed;
    private ArrayList<OrdReq> _requirements;
    private EquationContext _result;

    private DeductionHypothesis(ProofState state, ProofContext context, String hypoName, boolean inverse, ConstrainedSimplifier s, EquationPosition pos, EquationContext result, ArrayList<OrdReq> reqs) {
        super(state, context);
        this._simplifier = s;
        this._position = pos;
        this._hypothesisName = hypoName;
        this._inversed = inverse;
        this._result = result;
        this._requirements = reqs;
    }

    public static DeductionHypothesis createStep(PartialProof proof, Optional<OutputModule> m, Hypothesis hypo, boolean inverse, EquationPosition pos, Substitution subst) {
        ArrayList<OrdReq> requirements;
        EquationContext original;
        Equation hequ;
        ConstrainedSimplifier simpl = new ConstrainedSimplifier(inverse ? hequ.getRhs() : hequ.getLhs(), inverse ? hequ.getLhs() : hequ.getRhs(), (hequ = hypo.getEquation()).getConstraint(), hypo.getRenaming(), subst);
        if (!simpl.matchSubterm((original = proof.getProofState().getTopEquation()).getEquation(), pos, m, "induction hypothesis")) {
            return null;
        }
        simpl.matchEqualitiesInConstraint(original.getConstraint());
        if (!simpl.checkEverythingSubstituted(m)) {
            return null;
        }
        Equation neweq = original.getEquation().replaceSubterm(pos, simpl.queryReduct());
        if (!DeductionHypothesis.checkOrderingRequirements(original, pos, neweq, requirements = new ArrayList<OrdReq>())) {
            m.ifPresent(o -> o.println("The hypothesis cannot be applied, as it would cause an obviously unsatisfiable ordering requirement to be imposed.", new Object[0]));
            return null;
        }
        int id = proof.getProofState().getLastUsedIndex() + 1;
        EquationContext result = original.replace(neweq, id);
        return new DeductionHypothesis(proof.getProofState(), proof.getContext(), hypo.getName() + (inverse ? "^{-1}" : ""), inverse, simpl, pos, result, requirements);
    }

    private static boolean checkOrderingRequirements(EquationContext original, EquationPosition pos, Equation neweq, ArrayList<OrdReq> reqs) {
        Term q;
        Renaming renaming = original.getRenaming();
        if (original.getLeftGreaterTerm().isEmpty() && original.getRightGreaterTerm().isEmpty()) {
            return true;
        }
        Term sprime = null;
        Term tprime = null;
        if (pos.querySide() == EquationPosition.Side.Left) {
            if (!original.getLeftGreaterTerm().isEmpty()) {
                sprime = original.getLeftGreaterTerm().get();
            }
            if (!original.getRightGreaterTerm().isEmpty()) {
                tprime = original.getRightGreaterTerm().get();
            }
            Term s = original.getEquation().getLhs();
            q = neweq.getLhs();
            Term t = original.getEquation().getRhs();
        } else {
            if (!original.getRightGreaterTerm().isEmpty()) {
                sprime = original.getRightGreaterTerm().get();
            }
            if (!original.getLeftGreaterTerm().isEmpty()) {
                tprime = original.getLeftGreaterTerm().get();
            }
            Term s = original.getEquation().getRhs();
            q = neweq.getRhs();
            Term t = original.getEquation().getLhs();
        }
        if (sprime == null) {
            return true;
        }
        boolean sequalq = sprime.equals(q);
        Term lgamma = original.getEquation().querySubterm(pos);
        Term phi = neweq.getConstraint();
        if (!sequalq) {
            reqs.add(new OrdReq(sprime, q, phi, renaming));
        }
        if (!sprime.equals(lgamma)) {
            if (!sequalq) {
                return true;
            }
            if (!pos.queryPosition().isEmpty()) {
                return true;
            }
        }
        if (tprime.equals(q)) {
            return false;
        }
        reqs.add(new OrdReq(tprime, q, phi, renaming));
        return true;
    }

    public int queryRequirementCount() {
        return this._requirements.size();
    }

    public OrdReq queryRequirement(int index) {
        return this._requirements.get(index);
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        if ((Settings.queryRewritingStrategy().equals((Object)Settings.Strategy.Innermost) || Settings.queryRewritingStrategy().equals((Object)Settings.Strategy.CallByValue)) && !this._simplifier.checkSemiConstructorSubstitution(this._pcontext)) {
            module.ifPresent(o -> o.println("This step cannot be applied due to the innermost evaluation strategy.", new Object[0]));
            return false;
        }
        if (this._simplifier.constraintIsTrue()) {
            return true;
        }
        return this._simplifier.canReduceCtermWithConstraint(this._equ.getConstraint(), Settings.smtSolver, this._equ.getRenaming(), module, "induction hypothesis");
    }

    @Override
    protected ProofState tryApply(Optional<OutputModule> module) {
        ProofState tmp = this._state;
        for (OrdReq req : this._requirements) {
            tmp = tmp.addOrderingRequirement(req);
        }
        return tmp.replaceTopEquation(this._result);
    }

    @Override
    public String commandDescription() {
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        printer.add("hypothesis ", this._hypothesisName, " ", this._position, " with ", this._simplifier.substitutionPrintable(this._equ.getRenaming()));
        return printer.toString();
    }

    @Override
    public void explain(OutputModule module) {
        module.print("We apply HYPOTHESIS to %a with induction hypothesis %a and substitution %a.  ", this._equ.getName(), this._hypothesisName, this._simplifier.substitutionPrintable(this._equ.getRenaming()));
        if (this._requirements.size() == 0) {
            module.println("This does not cause any new ordering requirements to be imposed.", new Object[0]);
        } else if (this._requirements.size() == 1) {
            module.println("To this end, we impose the requirement that %a.", this._requirements.get(0));
        } else {
            module.print("To this end, we impose the requirements that ", new Object[0]);
            for (int i = 0; i < this._requirements.size(); ++i) {
                if (i == this._requirements.size() - 1) {
                    module.print(" and ", new Object[0]);
                } else if (i != 0) {
                    module.print(", ", new Object[0]);
                }
                module.print("%a", this._requirements.get(i));
            }
            module.println(".", new Object[0]);
        }
    }
}

