/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.Hypothesis;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.Optional;

public final class DeductionInduct
extends DeductionStep {
    private DeductionInduct(ProofState state, ProofContext context) {
        super(state, context);
    }

    public static DeductionInduct createStep(PartialProof proof, Optional<OutputModule> m) {
        ProofState state = proof.getProofState();
        if (state.isFinalState()) {
            m.ifPresent(o -> o.println("The proof is already complete.", new Object[0]));
            return null;
        }
        return new DeductionInduct(state, proof.getContext());
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        for (Hypothesis hypo : this._state.getHypotheses()) {
            if (hypo.getEquation() != this._equ.getEquation()) continue;
            module.ifPresent(o -> o.println("You already have this induction hypothesis (%a), so there is no benefit to using INDUCT again on this equation.", hypo.getName()));
            return false;
        }
        return true;
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        Hypothesis hypothesis = new Hypothesis(this._equ.getEquation(), this._equ.getIndex(), this._equ.getRenaming());
        if (!this._equ.getLeftGreaterTerm().isEmpty() && !this._equ.getRightGreaterTerm().isEmpty() && this._equ.getLeftGreaterTerm().get().equals(this._equ.getEquation().getLhs()) && this._equ.getRightGreaterTerm().get().equals(this._equ.getEquation().getRhs())) {
            return this._state.addHypothesis(hypothesis);
        }
        int index = this._state.getLastUsedIndex() + 1;
        Equation equation = this._equ.getEquation();
        EquationContext newequ = new EquationContext(equation.getLhs(), equation, equation.getRhs(), index, this._equ.getRenaming());
        FixedList.Builder<EquationContext> ecbuilder = new FixedList.Builder<EquationContext>();
        for (EquationContext ec : this._state.getEquations()) {
            if (ec == this._equ) {
                ecbuilder.add(newequ);
                continue;
            }
            ecbuilder.add(ec);
        }
        FixedList<EquationContext> newEquations = ecbuilder.build();
        FixedList<Hypothesis> newHypotheses = this._state.getHypotheses().append(hypothesis);
        return new ProofState(newEquations, newHypotheses, this._state.getOrderingRequirements(), this._state.getIncompleteEquations(), index);
    }

    @Override
    public String commandDescription() {
        return "induct";
    }

    @Override
    public void explain(OutputModule module) {
        module.println("We apply INDUCT to %a, which causes %a to be added to the set H of induction hypotheses.", this._equ.getName(), this._equ.getEquation().makePrintableWith(this._equ.getRenaming()));
    }
}

