/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.replaceable.Renaming;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.Optional;

public final class DeductionPostulate
extends DeductionStep {
    private Equation _equation;
    private Renaming _renaming;

    private DeductionPostulate(ProofState state, ProofContext context, Equation equ, Renaming ren) {
        super(state, context);
        this._equation = equ;
        this._renaming = ren.makeImmutable();
    }

    public static DeductionPostulate createStep(PartialProof proof, Optional<OutputModule> module, Equation equ, Renaming ren) {
        ProofState state = proof.getProofState();
        return new DeductionPostulate(proof.getProofState(), proof.getContext(), equ, ren.copy());
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        return true;
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        int newIndex = this._state.getLastUsedIndex() + 1;
        EquationContext n = new EquationContext(this._equation, newIndex, this._renaming);
        return this._state.addEquation(n).setIncomplete(newIndex);
    }

    @Override
    public String commandDescription() {
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        printer.add("postulate ", this._equation.makePrintableWith(this._renaming));
        return printer.toString();
    }

    @Override
    public void explain(OutputModule module) {
        module.println("We apply POSTULATE to add the lemma equation %a to the current proof state.", this._equation.makePrintableWith(this._renaming));
    }
}

