/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.substitution.Substitution;
import charlie.terms.Term;
import charlie.terms.Variable;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.trs.Rule;
import charlie.util.Pair;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.EquationPosition;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import cora.rwinduction.engine.deduction.ConstrainedSimplifier;
import cora.rwinduction.engine.deduction.DeductionAlterDefinitions;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;

public final class DeductionSimplify
extends DeductionStep {
    private String _ruleName;
    private EquationPosition _position;
    private DeductionAlterDefinitions _prealter;
    private ConstrainedSimplifier _simplifier;

    private DeductionSimplify(ProofState state, ProofContext context, String ruleName, EquationPosition pos, DeductionAlterDefinitions prealter, ConstrainedSimplifier simpl) {
        super(state, context);
        this._ruleName = ruleName;
        this._position = pos;
        this._prealter = prealter;
        this._simplifier = simpl;
    }

    public static DeductionSimplify createStep(PartialProof proof, Optional<OutputModule> m, String ruleName, EquationPosition pos, Substitution subst) {
        MutableRenaming ren;
        Function<Variable, Pair<Variable, String>> derivativeChooser;
        ArrayList<Pair<Pair<Variable, String>, Term>> definitions;
        EquationContext equ;
        ProofContext context = proof.getContext();
        Rule rule = context.getRule(ruleName);
        if (rule == null) {
            m.ifPresent(o -> o.println("No such rule: %a.", ruleName));
            return null;
        }
        ConstrainedSimplifier simpl = new ConstrainedSimplifier(rule.queryLeftSide(), rule.queryRightSide(), rule.queryConstraint(), context.getRenaming(ruleName), subst);
        if (!simpl.matchSubterm((equ = proof.getProofState().getTopEquation()).getEquation(), pos, m, "rule")) {
            return null;
        }
        DeductionAlterDefinitions prealter = null;
        if (!DeductionSimplify.constraintFullySubstituted(equ.getConstraint(), simpl.querySubstitution()) && (definitions = simpl.addDefinitionsToSubstitution(derivativeChooser = arg_0 -> DeductionSimplify.lambda$createStep$1(context, ren = equ.getRenaming().copy(), arg_0))).size() > 0) {
            prealter = DeductionAlterDefinitions.createStep(proof, m, definitions);
        }
        return new DeductionSimplify(proof.getProofState(), proof.getContext(), ruleName, pos, prealter, simpl);
    }

    private static boolean constraintFullySubstituted(Term constraint, Substitution subst) {
        for (Variable x : constraint.vars()) {
            if (subst.get(x) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        if ((Settings.queryRewritingStrategy().equals((Object)Settings.Strategy.Innermost) || Settings.queryRewritingStrategy().equals((Object)Settings.Strategy.CallByValue)) && !this._simplifier.checkSemiConstructorSubstitution(this._pcontext)) {
            module.ifPresent(o -> o.println("The rule can only be applied at an innermost position.", new Object[0]));
            return false;
        }
        if (this._simplifier.constraintIsTrue()) {
            return true;
        }
        if (this._prealter != null && !this._prealter.verify(module)) {
            return false;
        }
        if (!this._simplifier.checkEverythingSubstituted(module)) {
            return false;
        }
        Term constraint = this._equ.getEquation().getConstraint();
        return this._simplifier.canReduceCtermWithConstraint(constraint, Settings.smtSolver, this._equ.getRenaming(), module, "rule");
    }

    @Override
    protected ProofState tryApply(Optional<OutputModule> module) {
        Renaming renaming;
        Term substituted = this._simplifier.queryReduct();
        Equation ret = this._equ.getEquation().replaceSubterm(this._position, substituted);
        if (this._prealter == null) {
            renaming = this._equ.getRenaming();
        } else {
            ret = new Equation(ret.getLhs(), ret.getRhs(), this._prealter.queryUpdatedConstraint());
            renaming = this._prealter.queryUpdatedRenaming();
        }
        EquationContext ec = this._equ.replace(ret, renaming, this._state.getLastUsedIndex() + 1);
        return this._state.replaceTopEquation(ec);
    }

    @Override
    public String commandDescription() {
        Printer printer = PrinterFactory.createParseablePrinter(this._pcontext.getTRS());
        printer.add("simplify ", this._ruleName, " ", this._position, " with ", this._simplifier.substitutionPrintable(this._equ.getRenaming()));
        return printer.toString();
    }

    @Override
    public void explain(OutputModule module) {
        if (this._prealter == null) {
            module.print("We apply SIMPLIFICATION to %a", this._equ.getName());
        } else {
            module.print("We apply ALTER to add %a to the constraint of %a, and then we apply SIMPLIFICATION to the resulting equation", Printer.makePrintable(this._prealter.queryAddedConstraint(), this._prealter.queryUpdatedRenaming()), this._equ.getName());
        }
        module.println(" with rule %a and substitution %a.", this._ruleName, this._simplifier.substitutionPrintable(this._equ.getRenaming()));
    }

    private static /* synthetic */ Pair lambda$createStep$1(ProofContext context, MutableRenaming ren, Variable x) {
        Variable y = context.getVariableNamer().chooseDerivativeOrSameNaming(x, ren, x.queryType());
        return new Pair<Variable, String>(y, ren.getName(y));
    }
}

