/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.engine.deduction;

import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofContext;
import cora.rwinduction.engine.ProofState;
import java.util.Optional;

public final class DeductionSkip
extends DeductionStep {
    private DeductionSkip(ProofState state, ProofContext context) {
        super(state, context);
    }

    public static DeductionSkip createStep(PartialProof proof, Optional<OutputModule> module) {
        if (proof.getProofState().getEquations().size() == 0) {
            module.ifPresent(o -> o.println("The SKIP rule cannot be applied, since there are no equations.", new Object[0]));
            return null;
        }
        return new DeductionSkip(proof.getProofState(), proof.getContext());
    }

    @Override
    public boolean verify(Optional<OutputModule> module) {
        if (this._state.getEquations().size() == 1) {
            return this.println(module, "The SKIP rule cannot be applied, since there is only one equation.", new Object[0]);
        }
        return true;
    }

    @Override
    public ProofState tryApply(Optional<OutputModule> module) {
        FixedList<EquationContext> oldeqs = this._state.getEquations();
        FixedList.Builder<EquationContext> neweqs = new FixedList.Builder<EquationContext>(oldeqs.size());
        neweqs.add(oldeqs.get(oldeqs.size() - 1));
        for (int i = 0; i < oldeqs.size() - 1; ++i) {
            neweqs.add(oldeqs.get(i));
        }
        return new ProofState(neweqs.build(), this._state.getHypotheses(), this._state.getOrderingRequirements(), this._state.getIncompleteEquations(), this._state.getLastUsedIndex());
    }

    @Override
    public String commandDescription() {
        return "skip";
    }

    @Override
    public void explain(OutputModule module) {
        module.println("We apply SKIP, which does not change the existing equations, but does allow us to focus on a different one.", new Object[0]);
    }
}

