/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.parser;

import charlie.parser.CoraParser;
import charlie.parser.Parser;
import charlie.parser.lib.ParsingException;
import charlie.parser.lib.ParsingStatus;
import charlie.parser.lib.Token;
import charlie.reader.CoraInputReader;
import charlie.substitution.MutableSubstitution;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.trs.TRS;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.parser.EquationParser;
import cora.rwinduction.parser.RIParser;
import java.util.Optional;
import java.util.Set;

public class CommandParsingStatus {
    private String _mystring;
    private int _index;
    private int _lastIndex;

    public CommandParsingStatus(String str) {
        this._mystring = str;
        this._index = 0;
        this._lastIndex = -1;
        this.skipWhitespace();
    }

    private void skipWhitespace() {
        while (this._index < this._mystring.length() && Character.isWhitespace(this._mystring.charAt(this._index))) {
            ++this._index;
        }
    }

    public boolean done() {
        return this._index >= this._mystring.length();
    }

    public boolean commandEnded() {
        return this._index >= this._mystring.length() || this._mystring.charAt(this._index) == ';';
    }

    public boolean skipSeparator() {
        if (this._index >= this._mystring.length() || this._mystring.charAt(this._index) != ';') {
            return false;
        }
        ++this._index;
        this.skipWhitespace();
        return true;
    }

    public String nextWord() {
        if (this._index >= this._mystring.length() || this._mystring.charAt(this._index) == ';') {
            return null;
        }
        this._lastIndex = this._index++;
        while (this._index < this._mystring.length() && this._mystring.charAt(this._index) != ';' && !Character.isWhitespace(this._mystring.charAt(this._index))) {
            ++this._index;
        }
        String ret = this._mystring.substring(this._lastIndex, this._index);
        this.skipWhitespace();
        return ret;
    }

    public String readRest() {
        this._lastIndex = this._index;
        while (this._index < this._mystring.length() && this._mystring.charAt(this._index) != ';') {
            ++this._index;
        }
        return this._mystring.substring(this._lastIndex, this._index);
    }

    public boolean expect(String text, Optional<OutputModule> module) {
        if (this._index + text.length() <= this._mystring.length() && this._mystring.substring(this._index, this._index + text.length()).equals(text)) {
            this._lastIndex = this._index;
            this._index += text.length();
            while (this._index < this._mystring.length() && Character.isWhitespace(this._mystring.charAt(this._index))) {
                ++this._index;
            }
            return true;
        }
        if (this.commandEnded()) {
            module.ifPresent(o -> o.println("Unexpected end of input following token at position %a; I expected %a.", this.previousPosition(), text));
            return false;
        }
        String word = this.nextWord();
        module.ifPresent(o -> o.println("Unexpected input at position %a; I expected %a but got %a.", this.previousPosition(), text, word));
        return false;
    }

    public int currentPosition() {
        return this._index + 1;
    }

    public int previousPosition() {
        return this._lastIndex + 1;
    }

    private ParsingStatus makeStatus() {
        String alterString = " ".repeat(this._index) + this._mystring.substring(this._index);
        return RIParser.createStatus(alterString);
    }

    private void recoverPosition(ParsingStatus status) {
        this._lastIndex = this._index;
        this._index = status.peekNext().isEof() ? this._mystring.length() : status.peekNext().getColumn() - 1;
    }

    private void printErrorText(OutputModule module, ParsingException e) {
        String str = e.getMessage().trim();
        if (str.length() > 2 && str.substring(0, 2).equals("1:") && Character.isDigit(str.charAt(2))) {
            module.println("Parsing error at position %a", str.substring(2));
        } else {
            module.println("Parsing error: %a", str);
        }
    }

    public String readIdentifier(Optional<OutputModule> module, String desc) {
        ParsingStatus status = this.makeStatus();
        try {
            Token tok = status.expect("IDENTIFIER", desc);
            String ret = tok.getText();
            this.recoverPosition(status);
            return ret;
        }
        catch (ParsingException e) {
            module.ifPresent(o -> this.printErrorText((OutputModule)o, e));
            return null;
        }
    }

    public FunctionSymbol readSymbol(TRS trs, OutputModule module) {
        Term fterm;
        ParsingStatus status = this.makeStatus();
        try {
            Parser.ParserTerm pterm = CoraParser.readSingleSymbol(status);
            this.recoverPosition(status);
            fterm = CoraInputReader.readTerm(pterm, (Renaming)new MutableRenaming(Set.of()), trs);
        }
        catch (ParsingException e) {
            this.printErrorText(module, e);
            return null;
        }
        if (!fterm.isConstant()) {
            module.println("Unexpected term %a at position %a; I expected a single constant.", this._mystring.substring(this._lastIndex, this._index).trim(), this._index);
            return null;
        }
        return fterm.queryRoot();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Term readTerm(TRS trs, Renaming varnames, OutputModule module) {
        ParsingStatus status = this.makeStatus();
        Object vname = null;
        try {
            Parser.ParserTerm pterm23322 = CoraParser.readTerm(status);
            if (pterm23322 instanceof Parser.Identifier) {
                Parser.Identifier identifier = (Parser.Identifier)pterm23322;
                try {
                    Object name;
                    Object object = identifier.token();
                    Token tok = object;
                    vname = name = (object = identifier.name());
                }
                catch (Throwable pterm23322) {
                    throw new MatchException(pterm23322.toString(), pterm23322);
                }
            }
            this.recoverPosition(status);
            return CoraInputReader.readTerm(pterm23322, varnames, trs);
        }
        catch (ParsingException e) {
            if (vname != null) {
                module.println("Unknown variable: " + vname, new Object[0]);
                return null;
            }
            this.printErrorText(module, e);
            return null;
        }
    }

    public Pair<Equation, MutableRenaming> readEquation(TRS trs, OutputModule module) {
        ParsingStatus status = this.makeStatus();
        try {
            Pair<Equation, MutableRenaming> ret = EquationParser.parseEquation(status, trs);
            if (ret != null) {
                this.recoverPosition(status);
            }
            return ret;
        }
        catch (ParsingException e) {
            this.printErrorText(module, e);
            return null;
        }
    }

    public boolean skipTerm() {
        ParsingStatus status = this.makeStatus();
        try {
            Parser.ParserTerm pterm = CoraParser.readTerm(status);
            this.recoverPosition(status);
            return true;
        }
        catch (ParsingException e) {
            return false;
        }
    }

    public MutableSubstitution readSubstitution(TRS trs, Renaming keyNames, MutableRenaming valueNames, OutputModule module) {
        ParsingStatus status = this.makeStatus();
        MutableSubstitution ret = null;
        try {
            ret = this.parseSubstitution(status, trs, keyNames, valueNames, module);
        }
        catch (ParsingException e) {
            this.printErrorText(module, e);
        }
        if (ret == null) {
            while (!status.peekNext().isEof() && !status.nextToken().getName().equals("METACLOSE")) {
            }
        }
        this.recoverPosition(status);
        return ret;
    }

    private MutableSubstitution parseSubstitution(ParsingStatus status, TRS trs, Renaming keyNames, MutableRenaming valueNames, OutputModule module) {
        status.expect("METAOPEN", "substitution opening bracket [");
        MutableSubstitution subst = new MutableSubstitution();
        boolean first = true;
        while (status.readNextIf("METACLOSE") == null) {
            if (first) {
                first = false;
            } else {
                status.expect("COMMA", "comma");
            }
            Token vartok = status.expect("IDENTIFIER", "(meta-)variable name");
            status.expect("ASSIGN", ":=");
            Parser.ParserTerm pterm = CoraParser.readTerm(status);
            String varname = vartok.getText();
            Replaceable x = keyNames.getReplaceable(varname);
            if (x == null) {
                status.storeError(vartok, "No such variable: " + varname);
                return null;
            }
            Term term = CoraInputReader.readTermAndUpdateNaming(pterm, valueNames, trs, x.queryType());
            subst.extend(x, term);
        }
        return subst;
    }
}

