/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.parser;

import charlie.parser.CoraParser;
import charlie.parser.Parser;
import charlie.parser.lib.ParsingException;
import charlie.parser.lib.ParsingStatus;
import charlie.parser.lib.Token;
import charlie.printer.Printer;
import charlie.reader.CoraInputReader;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TheoryFactory;
import charlie.terms.Value;
import charlie.terms.Variable;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.trs.TRS;
import charlie.types.TypeFactory;
import charlie.util.FixedList;
import charlie.util.LookupMap;
import charlie.util.Pair;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.parser.RIParser;
import java.util.Optional;

public class EquationParser {
    public static Pair<Equation, MutableRenaming> parseEquation(String str, TRS trs) {
        ParsingStatus status = RIParser.createStatus(str);
        Pair<Equation, MutableRenaming> ret = EquationParser.parseEquation(status, trs);
        status.expect(Token.EOF, "end of input");
        return ret;
    }

    public static EquationContext parseEquationContext(String str, int index, TRS trs) {
        ParsingStatus status = RIParser.createStatus(str);
        return EquationParser.parseEquationContext(status, index, trs);
    }

    public static EquationContext parseEquationData(String str, TRS trs, int index) {
        ParsingStatus status = RIParser.createStatus(str);
        Pair<Equation, MutableRenaming> pair = EquationParser.parseEquation(status, trs);
        EquationContext ret = new EquationContext(pair.fst(), index, pair.snd());
        status.expect(Token.EOF, "end of input");
        return ret;
    }

    public static FixedList<EquationContext> parseEquationList(String str, TRS trs) {
        ParsingStatus status = RIParser.createStatus(str);
        FixedList.Builder<EquationContext> ret = new FixedList.Builder<EquationContext>();
        int index = 1;
        while (true) {
            Pair<Equation, MutableRenaming> pair = EquationParser.parseEquation(status, trs);
            ret.add(new EquationContext(pair.fst(), index, pair.snd()));
            if (status.readNextIf("SEPARATOR") == null) {
                status.expect(Token.EOF, "semi-colon or end of input");
            }
            if (status.peekNext().isEof()) {
                return ret.build();
            }
            ++index;
        }
    }

    public static EquationContext parseEquationContext(ParsingStatus status, int index, TRS trs) {
        if (status.expect("BRACKETOPEN", "opening bracket") == null) {
            return null;
        }
        Parser.ParserTerm leftgr = null;
        Parser.ParserTerm rightgr = null;
        Token tok = status.peekNext();
        if (tok.getText().equals("\u2022") || tok.getText().equals("*")) {
            status.nextToken();
        } else {
            leftgr = CoraParser.readTerm(status);
        }
        status.expect("COMMA", "comma");
        Pair<Equation, MutableRenaming> pair = EquationParser.parseEquation(status, trs);
        status.expect("COMMA", "comma");
        tok = status.peekNext();
        if (tok.getText().equals("\u2022") || tok.getText().equals("*")) {
            status.nextToken();
        } else {
            rightgr = CoraParser.readTerm(status);
        }
        status.expect("BRACKETCLOSE", "closing bracket");
        Optional<Object> lg = leftgr == null ? Optional.empty() : Optional.of(CoraInputReader.readTermAndUpdateNaming(leftgr, pair.snd(), trs, null));
        Optional<Object> rg = rightgr == null ? Optional.empty() : Optional.of(CoraInputReader.readTermAndUpdateNaming(rightgr, pair.snd(), trs, null));
        return new EquationContext(lg, pair.fst(), rg, index, (Renaming)pair.snd());
    }

    public static Pair<Equation, MutableRenaming> parseEquation(ParsingStatus status, TRS trs) {
        MutableRenaming renaming = new MutableRenaming(trs.queryFunctionSymbolNames());
        return new Pair<Equation, MutableRenaming>(EquationParser.parseEquation(status, renaming, trs), renaming);
    }

    private static void readEnvironment(ParsingStatus status, MutableRenaming renaming) {
        if (!status.peekNext().getName().equals("BRACEOPEN")) {
            return;
        }
        LookupMap<Parser.ParserDeclaration> env = CoraParser.readEnvironment(status);
        for (Parser.ParserDeclaration decl : env.values()) {
            Variable x = TermFactory.createVar(decl.name(), decl.type());
            if (!renaming.setName(x, decl.name())) {
                throw ParsingException.create(decl.token(), "Unexpected variable ", decl.name(), "in environment: I could not use this as a variable name (is it already in use as a function symbol name?)");
            }
            if (decl.extra() == 0) continue;
            throw ParsingException.create(decl.token(), "Unexpected meta-variable ", decl.name(), "in environment: for now, rewriting induction only considers applicative terms, so meta-variables with arity are not permitted.");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Equation parseEquation(ParsingStatus status, MutableRenaming renaming, TRS trs) {
        Parser.ParserTerm left;
        Parser.ParserTerm constr;
        Parser.ParserTerm right;
        Token tok;
        block9: {
            EquationParser.readEnvironment(status, renaming);
            tok = status.peekNext();
            right = null;
            constr = null;
            left = CoraParser.readTerm(status);
            if (status.readNextIf("APPROX") != null) {
                right = CoraParser.readTerm(status);
            } else if (left instanceof Parser.Application) {
                FixedList<Parser.ParserTerm> args;
                FixedList<Parser.ParserTerm> head;
                Object object;
                Parser.Application application = (Parser.Application)left;
                try {
                    object = application.token();
                    Token tok1 = object;
                    object = application.head();
                    head = object;
                    object = application.args();
                    args = object;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (head instanceof Parser.CalcSymbol) {
                    Parser.CalcSymbol calcSymbol = (Parser.CalcSymbol)((Object)head);
                    {
                        Object tok2 = object = calcSymbol.token();
                        Object name = object = calcSymbol.name();
                        if (args.size() != 2 || !((String)name).equals("=")) break block9;
                        left = args.get(0);
                        right = args.get(1);
                    }
                }
            }
        }
        Term l = CoraInputReader.readTermAndUpdateNaming(left, renaming, trs, null);
        if (right == null) {
            throw ParsingException.create(tok, "Unexpected equation: I expected a form \"a -><- b (| c)?\" but only found one term: ", Printer.makePrintable(l, (Renaming)renaming), ".");
        }
        if (status.readNextIf("MID") != null) {
            constr = CoraParser.readTerm(status);
        }
        Term r = CoraInputReader.readTermAndUpdateNaming(right, renaming, trs, l.queryType());
        Value constraint = constr == null ? TheoryFactory.createValue(true) : CoraInputReader.readTermAndUpdateNaming(constr, renaming, trs, TypeFactory.boolSort);
        EquationParser.checkEquation(tok, l, r, constraint, renaming);
        return new Equation(l, r, constraint);
    }

    private static void checkEquation(Token token, Term left, Term right, Term constraint, Renaming renaming) {
        if (!left.queryType().equals(right.queryType())) {
            throw ParsingException.create(token, "Left-hand side of equation (", Printer.makePrintable(left, renaming), ") has type ", left.queryType(), " while right-hand side (", Printer.makePrintable(right, renaming), ") has type ", right.queryType(), "!");
        }
        if (!constraint.queryType().equals(TypeFactory.boolSort)) {
            throw ParsingException.create(token, "Constraint ", Printer.makePrintable(constraint, renaming), " has type ", constraint.queryType(), " (should be Bool)");
        }
    }
}

