/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.parser;

import charlie.parser.CoraTokenData;
import charlie.parser.lib.Lexer;
import charlie.parser.lib.LexerException;
import charlie.parser.lib.ParsingStatus;
import charlie.parser.lib.Token;
import charlie.parser.lib.TokenEditLexer;
import charlie.parser.lib.TokenQueue;
import charlie.trs.TRS;

public class RIParser {
    public static final String APPROX = "APPROX";
    public static final String ASSIGN = "ASSIGN";
    public static final String SEPARATOR = "SEPARATOR";

    public static String checkTrs(TRS trs) {
        for (String s : trs.queryFunctionSymbolNames()) {
            if (s.indexOf("\u2248") < 0 && s.indexOf(":=") < 0 && s.indexOf(";") < 0) continue;
            return "This TRS has a function symbol " + s + " that would interfere with the input language of the interactive prover.  Therefore, it is unfortunately not possible to use the interactive prover.";
        }
        return null;
    }

    public static ParsingStatus createStatus(String str) {
        String positionItem = "((-|!)?[0-9]+)";
        TokenQueue queue = CoraTokenData.getUpdatedConstrainedStringLexer(str, lexer -> new SplitApproxAndSeparatorLexer((Lexer)lexer), "\u2248", APPROX, "-><-", APPROX, "\\[=\\]", APPROX, ":=", ASSIGN, ";", SEPARATOR);
        return new ParsingStatus(queue, 1);
    }

    private static class SplitApproxAndSeparatorLexer
    extends TokenEditLexer {
        SplitApproxAndSeparatorLexer(Lexer lexer) {
            super(lexer, "IDENTIFIER");
        }

        @Override
        protected void modifyToken(Token token) throws LexerException {
            String txt = token.getText();
            int start = 0;
            while (start < txt.length()) {
                int best = txt.length();
                String bestKind = null;
                int a = txt.indexOf(8776, start);
                int b = txt.indexOf(59, start);
                if (a != -1) {
                    best = a;
                    bestKind = RIParser.APPROX;
                }
                if (b != -1 && b < best) {
                    best = b;
                    bestKind = RIParser.SEPARATOR;
                }
                if (best > start || bestKind == null) {
                    Token tok;
                    String sub = txt.substring(start, best);
                    TokenQueue sublexer = CoraTokenData.getConstrainedStringLexer(sub);
                    while (!(tok = sublexer.nextToken()).isEof()) {
                        this.storeToken(token, start + tok.getColumn() - 1, tok.getName(), tok.getText());
                    }
                }
                if (bestKind != null) {
                    this.storeToken(token, best, bestKind, txt.substring(best, best + 1));
                }
                start = best + 1;
            }
        }
    }
}

