/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.tui;

import cora.rwinduction.tui.Inputter;
import cora.rwinduction.tui.QuitInputter;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

public class CacheInputter
implements Inputter {
    private Inputter _child;
    private Stack<String> _cache;

    public CacheInputter(List<String> cached, Inputter child) {
        this._child = child;
        this._cache = new Stack();
        ListIterator<String> li = cached.listIterator(cached.size());
        while (li.hasPrevious()) {
            this._cache.push(li.previous());
        }
    }

    public CacheInputter(Inputter child) {
        this._child = child;
        this._cache = new Stack();
    }

    public CacheInputter() {
        this._child = new QuitInputter();
        this._cache = new Stack();
    }

    public void cache(String str) {
        this._cache.push(str);
    }

    @Override
    public String readLine() {
        if (this._cache.empty()) {
            return this._child.readLine();
        }
        return this._cache.pop();
    }

    @Override
    public String readLine(String prompt) {
        if (this._cache.empty()) {
            return this._child.readLine(prompt);
        }
        return this._cache.pop();
    }

    @Override
    public void close() {
        this._child.close();
    }
}

