/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.tui;

import charlie.util.ExceptionLogger;
import cora.rwinduction.tui.Inputter;
import cora.rwinduction.tui.QuitInputter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class FileInputter
implements Inputter {
    private Inputter _child;
    private BufferedReader _reader;

    public FileInputter(String filename, Inputter child) throws IOException {
        this._child = child;
        this._reader = new BufferedReader(new FileReader(filename));
    }

    public FileInputter(String filename) throws IOException {
        this._child = new QuitInputter();
        this._reader = new BufferedReader(new FileReader(filename));
    }

    private String tryReadFromReader() {
        if (this._reader == null) {
            return null;
        }
        try {
            String line = this._reader.readLine();
            if (line != null) {
                return line;
            }
        }
        catch (IOException e) {
            ExceptionLogger.log("Encountered IOException while trying to read from file.", e);
        }
        this._reader = null;
        return null;
    }

    @Override
    public String readLine() {
        String ret = this.tryReadFromReader();
        if (ret != null) {
            return ret;
        }
        return this._child.readLine();
    }

    @Override
    public String readLine(String prompt) {
        String ret = this.tryReadFromReader();
        if (ret != null) {
            return ret;
        }
        return this._child.readLine(prompt);
    }

    @Override
    public void close() {
        this._child.close();
    }
}

