/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.tui;

import charlie.util.Pair;
import cora.rwinduction.command.CmdList;
import cora.rwinduction.command.Command;
import java.util.List;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

class ParameterCompleter
implements Completer {
    private CmdList _commands;

    ParameterCompleter(CmdList cmds) {
        this._commands = cmds;
    }

    private Pair<String, String> split(ParsedLine p) {
        String sofar = p.line();
        int index = sofar.lastIndexOf(32);
        if (index == -1) {
            return new Pair<String, String>("", "");
        }
        if ((index = (sofar = sofar.substring(0, index).trim()).indexOf(32)) == -1) {
            return new Pair<String, String>(sofar, "");
        }
        String cmd = sofar.substring(0, index);
        String args = sofar.substring(index + 1).trim();
        return new Pair<String, String>(cmd, args);
    }

    public void complete(LineReader r, ParsedLine p, List<Candidate> candidates) {
        Pair<String, String> parts = this.split(p);
        if (parts.fst().equals("")) {
            for (String cmd : this._commands.queryCommands()) {
                candidates.add(new Candidate(cmd, cmd, "", null, "", cmd, true));
            }
            return;
        }
        Command cmd = this._commands.queryCommand(parts.fst());
        if (cmd == null) {
            return;
        }
        List<Command.TabSuggestion> suggestions = cmd.suggestNext(parts.snd());
        for (Command.TabSuggestion option : suggestions) {
            String txt = option.text();
            String category = option.category();
            if (txt != null) {
                candidates.add(new Candidate(txt, txt, category, null, "", txt, true));
                continue;
            }
            if (suggestions.size() > 1) {
                candidates.add(new Candidate("", "", category, "<" + category + ">", "", category, true));
                continue;
            }
            candidates.add(new Candidate("", "", null, "<" + category + ">", "", category, true));
        }
    }
}

