/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.tui;

import charlie.util.ExceptionLogger;
import cora.rwinduction.command.CmdList;
import cora.rwinduction.tui.BasicInputter;
import cora.rwinduction.tui.Inputter;
import cora.rwinduction.tui.ParameterCompleter;
import java.io.IOException;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class ReplInputter
implements Inputter {
    private Terminal _terminal;
    private LineReader _lineReader;
    private BasicInputter _backup;

    public ReplInputter(CmdList cmds) {
        try {
            this._terminal = TerminalBuilder.terminal();
            DefaultParser parser = new DefaultParser();
            parser.setEscapeChars(null);
            this._lineReader = LineReaderBuilder.builder().terminal(this._terminal).completer((Completer)new ParameterCompleter(cmds)).parser((Parser)parser).build();
            this._backup = null;
        }
        catch (IOException e) {
            ExceptionLogger.log("Could not create interactive terminal.  Please use the settings to use the Basic inputter instead.", e);
            this._terminal = null;
            this._backup = new BasicInputter();
        }
    }

    @Override
    public String readLine(String prompt) {
        if (this._backup != null) {
            return this._backup.readLine(prompt);
        }
        return this._lineReader.readLine(prompt);
    }

    @Override
    public void close() {
        try {
            this._terminal.close();
        }
        catch (IOException e) {
            ExceptionLogger.log("Could not close interactive terminal.", e);
        }
        this._terminal = null;
    }
}

